/*
 * Decompiled with CFR 0.152.
 */
package com.wltea.analyzer.seg;

import com.wltea.analyzer.Context;
import com.wltea.analyzer.Lexeme;
import com.wltea.analyzer.dic.Dictionary;
import com.wltea.analyzer.dic.Hit;
import com.wltea.analyzer.help.CharacterHelper;
import com.wltea.analyzer.seg.ISegmenter;
import java.util.HashSet;
import java.util.Set;

public class QuantifierSegmenter
implements ISegmenter {
    public static final int NC_ARABIC = 2;
    public static final int NC_ANM = 3;
    public static final int NC_NP = 11;
    public static final int NC_CHINESE = 12;
    public static final int NC_CNM = 13;
    public static final int NC_NE = 14;
    public static final int NaN = -99;
    public static String Arabic_Num_Mid;
    public static String Num_Pre;
    public static String Chn_Num;
    public static String Chn_Num_Mid;
    public static String Num_End;
    private static Set<Character> ArabicNumMidChars;
    private static Set<Character> ChnNumberChars;
    private static Set<Character> NumEndChars;
    private static Set<Character> AllNumberChars;
    private int nStart = -1;
    private int nEnd = -1;
    private int nStatus = -99;
    private boolean fCaN = false;
    private int countStart = -1;
    private int countEnd = -1;

    @Override
    public void nextLexeme(char[] segmentBuff, Context context) {
        this.fCaN = false;
        this.processNumber(segmentBuff, context);
        if (this.countStart == -1) {
            if (this.fCaN && this.nStart == -1 || this.nEnd != -1 && this.nEnd == context.getCursor() - 1) {
                this.processCount(segmentBuff, context);
            }
        } else {
            this.processCount(segmentBuff, context);
        }
        if (this.nStart == -1 && this.nEnd == -1 && -99 == this.nStatus && this.countStart == -1 && this.countEnd == -1) {
            context.unlockBuffer(this);
        } else {
            context.lockBuffer(this);
        }
    }

    private void processNumber(char[] segmentBuff, Context context) {
        int inputStatus = this.nIdentify(segmentBuff, context);
        if (-99 == this.nStatus) {
            this.onNaNStatus(inputStatus, context);
        } else if (2 == this.nStatus) {
            this.onARABICStatus(inputStatus, context);
        } else if (3 == this.nStatus) {
            this.onANMStatus(inputStatus, context);
        } else if (11 == this.nStatus) {
            this.onNPStatus(inputStatus, context);
        } else if (12 == this.nStatus) {
            this.onCHINESEStatus(inputStatus, context);
        } else if (13 == this.nStatus) {
            this.onCNMStatus(inputStatus, context);
        } else if (14 == this.nStatus) {
            this.onCNEStatus(inputStatus, context);
        }
        if (context.getCursor() == context.getAvailable() - 1) {
            if (this.nStart != -1 && this.nEnd != -1) {
                this.outputNumLexeme(context);
            }
            this.nReset();
        }
    }

    private void onNaNStatus(int inputStatus, Context context) {
        if (-99 == inputStatus) {
            return;
        }
        if (11 == inputStatus) {
            this.nStart = context.getCursor();
            this.nStatus = inputStatus;
        } else if (12 == inputStatus) {
            this.nStart = context.getCursor();
            this.nStatus = inputStatus;
            this.nEnd = context.getCursor();
        } else if (14 == inputStatus) {
            this.nStart = context.getCursor();
            this.nStatus = inputStatus;
            this.nEnd = context.getCursor();
        } else if (2 == inputStatus) {
            this.nStart = context.getCursor();
            this.nStatus = inputStatus;
            this.nEnd = context.getCursor();
        }
    }

    private void onARABICStatus(int inputStatus, Context context) {
        if (2 == inputStatus) {
            this.nEnd = context.getCursor();
        } else if (3 == inputStatus) {
            this.nStatus = inputStatus;
        } else if (12 == inputStatus) {
            this.nEnd = context.getCursor();
            this.nStatus = inputStatus;
        } else if (14 == inputStatus) {
            this.nEnd = context.getCursor();
            this.nStatus = inputStatus;
        } else {
            this.outputNumLexeme(context);
            this.nReset();
            this.onNaNStatus(inputStatus, context);
        }
    }

    private void onANMStatus(int inputStatus, Context context) {
        if (2 == inputStatus) {
            this.nStatus = inputStatus;
            this.nEnd = context.getCursor();
        } else {
            this.outputNumLexeme(context);
            this.nReset();
            this.onNaNStatus(inputStatus, context);
        }
    }

    private void onNPStatus(int inputStatus, Context context) {
        if (12 == inputStatus) {
            this.nEnd = context.getCursor();
            this.nStatus = inputStatus;
        } else if (2 == inputStatus) {
            this.nEnd = context.getCursor();
            this.nStatus = inputStatus;
        } else {
            this.nReset();
            this.onNaNStatus(inputStatus, context);
        }
    }

    private void onCHINESEStatus(int inputStatus, Context context) {
        if (12 == inputStatus) {
            this.nEnd = context.getCursor();
        } else if (13 == inputStatus) {
            this.nStatus = inputStatus;
        } else if (14 == inputStatus) {
            this.nStatus = inputStatus;
            this.nEnd = context.getCursor();
        } else {
            this.outputNumLexeme(context);
            this.nReset();
            this.onNaNStatus(inputStatus, context);
        }
    }

    private void onCNMStatus(int inputStatus, Context context) {
        if (12 == inputStatus) {
            this.nStatus = inputStatus;
            this.nEnd = context.getCursor();
        } else if (14 == inputStatus) {
            this.nStatus = inputStatus;
            this.nEnd = context.getCursor();
        } else {
            this.outputNumLexeme(context);
            this.nReset();
            this.onNaNStatus(inputStatus, context);
        }
    }

    private void onCNEStatus(int inputStatus, Context context) {
        this.outputNumLexeme(context);
        this.nReset();
        this.onNaNStatus(inputStatus, context);
    }

    private void outputNumLexeme(Context context) {
        if (this.nStart > -1 && this.nEnd > -1) {
            Lexeme newLexeme = new Lexeme(context.getBuffOffset(), this.nStart, this.nEnd - this.nStart + 1, 10);
            context.addLexeme(newLexeme);
            this.fCaN = true;
        }
    }

    private void outputCountLexeme(Context context) {
        if (this.countStart > -1 && this.countEnd > -1) {
            Lexeme countLexeme = new Lexeme(context.getBuffOffset(), this.countStart, this.countEnd - this.countStart + 1, 11);
            context.addLexeme(countLexeme);
        }
    }

    private void nReset() {
        this.nStart = -1;
        this.nEnd = -1;
        this.nStatus = -99;
    }

    private int nIdentify(char[] segmentBuff, Context context) {
        char input = segmentBuff[context.getCursor()];
        int type = -99;
        if (!AllNumberChars.contains(Character.valueOf(input))) {
            return type;
        }
        if (CharacterHelper.isArabicNumber(input)) {
            type = 2;
        } else if (ChnNumberChars.contains(Character.valueOf(input))) {
            type = 12;
        } else if (Num_Pre.indexOf(input) >= 0) {
            type = 11;
        } else if (Chn_Num_Mid.indexOf(input) >= 0) {
            type = 13;
        } else if (NumEndChars.contains(Character.valueOf(input))) {
            type = 14;
        } else if (ArabicNumMidChars.contains(Character.valueOf(input))) {
            type = 3;
        }
        return type;
    }

    private void processCount(char[] segmentBuff, Context context) {
        Hit hit = null;
        hit = this.countStart == -1 ? Dictionary.matchInQuantifierDict(segmentBuff, context.getCursor(), 1) : Dictionary.matchInQuantifierDict(segmentBuff, this.countStart, context.getCursor() - this.countStart + 1);
        if (hit != null) {
            if (hit.isPrefix() && this.countStart == -1) {
                this.countStart = context.getCursor();
            }
            if (hit.isMatch()) {
                if (this.countStart == -1) {
                    this.countStart = context.getCursor();
                }
                this.countEnd = context.getCursor();
                this.outputCountLexeme(context);
            }
            if (hit.isUnmatch() && this.countStart != -1) {
                this.countStart = -1;
                this.countEnd = -1;
            }
        }
        if (context.getCursor() == context.getAvailable() - 1) {
            this.countStart = -1;
            this.countEnd = -1;
        }
    }

    @Override
    public void reset() {
        this.nStart = -1;
        this.nEnd = -1;
        this.nStatus = -99;
        this.fCaN = false;
        this.countStart = -1;
        this.countEnd = -1;
    }

    static {
        char[] ca;
        Arabic_Num_Mid = ",./:Ee";
        Num_Pre = "\u7b2c\u521d";
        Chn_Num = "\u25cb\u4e00\u4e8c\u4e24\u4e09\u56db\u4e94\u516d\u4e03\u516b\u4e5d\u5341\u96f6\u58f9\u8d30\u53c1\u8086\u4f0d\u9646\u67d2\u634c\u7396\u62fe\u767e\u5343\u4e07\u4ebf\u62fe\u4f70\u4edf\u842c\u5104\u5146\u5345\u5eff";
        Chn_Num_Mid = "\u70b9";
        Num_End = "\u51e0\u591a\u4f59\u534a";
        ArabicNumMidChars = new HashSet<Character>();
        ChnNumberChars = new HashSet<Character>();
        NumEndChars = new HashSet<Character>();
        AllNumberChars = new HashSet<Character>(256);
        for (char nChar : ca = Arabic_Num_Mid.toCharArray()) {
            ArabicNumMidChars.add(Character.valueOf(nChar));
        }
        for (char nChar : ca = Chn_Num.toCharArray()) {
            ChnNumberChars.add(Character.valueOf(nChar));
        }
        for (char nChar : ca = Num_End.toCharArray()) {
            NumEndChars.add(Character.valueOf(nChar));
        }
        ca = null;
        for (char nChar = '0'; nChar <= '9'; nChar = (char)(nChar + '\u0001')) {
            AllNumberChars.add(Character.valueOf(nChar));
        }
        AllNumberChars.addAll(ArabicNumMidChars);
        for (char nChar : ca = Num_Pre.toCharArray()) {
            AllNumberChars.add(Character.valueOf(nChar));
        }
        AllNumberChars.addAll(ChnNumberChars);
        for (char nChar : ca = Chn_Num_Mid.toCharArray()) {
            AllNumberChars.add(Character.valueOf(nChar));
        }
        AllNumberChars.addAll(NumEndChars);
    }
}

