/*
 * Decompiled with CFR 0.152.
 */
package com.wltea.analyzer.seg;

import com.wltea.analyzer.Context;
import com.wltea.analyzer.Lexeme;
import com.wltea.analyzer.help.CharacterHelper;
import com.wltea.analyzer.seg.ISegmenter;

public class LetterSegmenter
implements ISegmenter {
    public static final char[] Sign_Connector = new char[]{'+', '-', '_', '.', '@', '&', '/', '\\'};
    private int start = -1;
    private int end = -1;
    private int letterStart = -1;
    private int letterEnd = -1;

    @Override
    public void nextLexeme(char[] segmentBuff, Context context) {
        char input = segmentBuff[context.getCursor()];
        boolean bufferLockFlag = false;
        bufferLockFlag = this.processMixLetter(input, context) || bufferLockFlag;
        boolean bl = bufferLockFlag = this.processEnglishLetter(input, context) || bufferLockFlag;
        if (bufferLockFlag) {
            context.lockBuffer(this);
        } else {
            context.unlockBuffer(this);
        }
    }

    private boolean processMixLetter(char input, Context context) {
        Lexeme newLexeme;
        boolean needLock = false;
        if (this.start == -1) {
            if (this.isAcceptedCharStart(input)) {
                this.end = this.start = context.getCursor();
            }
        } else if (this.isAcceptedChar(input)) {
            this.end = context.getCursor();
        } else {
            newLexeme = new Lexeme(context.getBuffOffset(), this.start, this.end - this.start + 1, 20);
            context.addLexeme(newLexeme);
            this.start = -1;
            this.end = -1;
        }
        if (context.getCursor() == context.getAvailable() - 1) {
            if (this.start != -1 && this.end != -1) {
                newLexeme = new Lexeme(context.getBuffOffset(), this.start, this.end - this.start + 1, 20);
                context.addLexeme(newLexeme);
            }
            this.start = -1;
            this.end = -1;
        }
        needLock = this.start != -1 || this.end != -1;
        return needLock;
    }

    private boolean processEnglishLetter(char input, Context context) {
        Lexeme newLexeme;
        boolean needLock = false;
        if (this.letterStart == -1) {
            if (CharacterHelper.isEnglishLetter(input)) {
                this.letterEnd = this.letterStart = context.getCursor();
            }
        } else if (CharacterHelper.isEnglishLetter(input)) {
            this.letterEnd = context.getCursor();
        } else {
            newLexeme = new Lexeme(context.getBuffOffset(), this.letterStart, this.letterEnd - this.letterStart + 1, 20);
            context.addLexeme(newLexeme);
            this.letterStart = -1;
            this.letterEnd = -1;
        }
        if (context.getCursor() == context.getAvailable() - 1) {
            if (this.letterStart != -1 && this.letterEnd != -1) {
                newLexeme = new Lexeme(context.getBuffOffset(), this.letterStart, this.letterEnd - this.letterStart + 1, 20);
                context.addLexeme(newLexeme);
            }
            this.letterStart = -1;
            this.letterEnd = -1;
        }
        needLock = this.letterStart != -1 || this.letterEnd != -1;
        return needLock;
    }

    private boolean isLetterConnector(char input) {
        for (char c : Sign_Connector) {
            if (c != input) continue;
            return true;
        }
        return false;
    }

    private boolean isAcceptedCharStart(char input) {
        return CharacterHelper.isEnglishLetter(input) || CharacterHelper.isArabicNumber(input);
    }

    private boolean isAcceptedChar(char input) {
        return this.isLetterConnector(input) || CharacterHelper.isEnglishLetter(input) || CharacterHelper.isArabicNumber(input);
    }

    @Override
    public void reset() {
        this.start = -1;
        this.end = -1;
        this.letterStart = -1;
        this.letterEnd = -1;
    }
}

