/*
 * Decompiled with CFR 0.152.
 */
package com.wltea.analyzer.lucene;

import com.wltea.analyzer.lucene.IKTokenizer;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.synonym.SynonymFilterFactory;
import org.apache.lucene.analysis.util.FilesystemResourceLoader;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.lucene.util.Version;

public class IKSynonymAnalyzer
extends Analyzer {
    private final Version matchVersion;
    private boolean useSmart;

    public IKSynonymAnalyzer() {
        this(Version.LUCENE_4_9, false);
    }

    public IKSynonymAnalyzer(Version matchVersion, boolean useSmart) {
        this.matchVersion = matchVersion;
        this.useSmart = useSmart;
    }

    public boolean useSmart() {
        return this.useSmart;
    }

    public void setUseSmart(boolean useSmart) {
        this.useSmart = useSmart;
    }

    protected Analyzer.TokenStreamComponents createComponents(String fieldName, Reader in) {
        IKTokenizer tokenizer = new IKTokenizer(in, this.useSmart());
        HashMap<String, String> filterArgs = new HashMap<String, String>();
        filterArgs.put("luceneMatchVersion", this.matchVersion.toString());
        filterArgs.put("synonyms", "com/wltea/analyzer/dic/synonyms.dic");
        filterArgs.put("expand", "true");
        SynonymFilterFactory factory = new SynonymFilterFactory(filterArgs);
        try {
            factory.inform((ResourceLoader)new FilesystemResourceLoader());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)tokenizer, factory.create((TokenStream)tokenizer));
    }
}

