/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.sdk.dto.req.SmsNoticeSendInfoReq;
import com.baijiayun.duanxunbao.sdk.dto.req.SmsNoticeSendReq;
import com.baijiayun.duanxunbao.sdk.dto.req.SmsOpenReq;
import com.baijiayun.duanxunbao.sdk.dto.req.SmsSendDetailReq;
import com.baijiayun.duanxunbao.sdk.dto.req.SmsSendReq;
import com.baijiayun.duanxunbao.sdk.dto.resp.SmsCheckUrlResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.SmsSendDetail;
import com.baijiayun.duanxunbao.sdk.dto.resp.SmsSendResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.SmsTemplateInfoResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.SmsTemplateUploadResp;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.baijiayun.duanxunbao.sdk.service.SmsService;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsServiceImpl
implements SmsService {
    private static final Logger log = LoggerFactory.getLogger(SmsServiceImpl.class);
    private static final int SEND_DETAIL_LIMIT = 100;
    private static final String SEND_ID = "send_id";
    private static final String CONTENT = "content";
    private static final String CORP_ID = "corp_id";
    private static final String SMS_SIGN = "sms_sign";
    @Autowired
    private BjyPartnerService bjyPartnerService;

    @Override
    public SmsCheckUrlResp checkUrl(String partnerId, String token, String content) {
        log.info("checkUrl partnerId: {}, token: {}, content:{}", new Object[]{partnerId, token, content});
        Map<String, String> map = this.getCheckParams(content);
        SmsCheckUrlResp resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/availableQuantity", map);
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return null;
            }
            resp = (SmsCheckUrlResp)JSONObject.parseObject((String)data.toJSONString(), SmsCheckUrlResp.class);
        }
        catch (Exception e) {
            log.error("checkUrl error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public SmsSendDetail noticeSendInfo(String partnerId, String token, SmsNoticeSendInfoReq req) {
        log.info("noticeSendInfo partnerId: {}, token: {}, req:{}", new Object[]{partnerId, token, req});
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("msg_id", req.getMsgId());
        params.put("mobile", req.getMobile());
        SmsSendDetail sendDetail = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/noticeSendInfo", params);
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return null;
            }
            sendDetail = (SmsSendDetail)JSONObject.parseObject((String)data.toJSONString(), SmsSendDetail.class);
        }
        catch (Exception e) {
            log.error("get notice sms detail error", (Throwable)e);
        }
        return sendDetail;
    }

    @Override
    public JSONObject noticeSend(String partnerId, String token, SmsNoticeSendReq req) {
        log.info("noticeSend partnerId: {}, token: {}, req:{}", new Object[]{partnerId, token, req});
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put(SMS_SIGN, req.getSmsSign());
        params.put(CONTENT, req.getContent());
        params.put("to", req.getTo());
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/noticeSend", params);
    }

    @Override
    public JSONObject open(String partnerId, String token, SmsOpenReq req) {
        log.info("open partnerId: {}, token: {}, req:{}", new Object[]{partnerId, token, req});
        Map<String, String> params = this.getOpenParams(req.getUnitPrice(), req.getPartnerId());
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/open", params);
    }

    @Override
    public JSONObject sendDetail(String partnerId, String token, SmsSendDetailReq req) {
        log.info("sendDetail partnerId: {}, token: {}, req:{}", new Object[]{partnerId, token, req});
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put(SEND_ID, req.getSendId());
        params.put("page", String.valueOf(req.getPage()));
        params.put("page_size", String.valueOf(req.getPageSize()));
        return this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/sendDetail", params);
    }

    @Override
    public SmsSendResp send(String partnerId, String token, SmsSendReq req) {
        log.info("send partnerId: {}, token: {}, req:{}", new Object[]{partnerId, token, req});
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put(SMS_SIGN, req.getSmsSign());
        params.put(CONTENT, req.getContent());
        params.put("type", req.getType());
        params.put("to", req.getTo());
        params.put("custom_params", req.getCustomParams());
        SmsSendResp sendResp = new SmsSendResp();
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/send", params);
            JSONObject data = jsonObject.getJSONObject("data");
            int code = jsonObject.getIntValue("code");
            String msg = jsonObject.getString("msg");
            if (code != 0) {
                sendResp.setMsg(msg);
                return sendResp;
            }
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return sendResp;
            }
            sendResp = (SmsSendResp)JSONObject.parseObject((String)data.toJSONString(), SmsSendResp.class);
        }
        catch (Exception e) {
            log.error("send error", (Throwable)e);
            sendResp.setMsg(e.getMessage());
        }
        return sendResp;
    }

    @Override
    public void templateDelete(String partnerId, String token, List<String> templateIds) {
        log.info("send partnerId: {}, token: {}, templateId:{}", new Object[]{partnerId, token, templateIds});
        Map<String, String> deleteParams = this.getTemplateDeleteParams(templateIds);
        this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/templateDelete", deleteParams);
    }

    @Override
    public SmsTemplateUploadResp templateUpload(String partnerId, String token, String content) {
        log.info("templateUpload partnerId: {}, token: {}, content:{}", new Object[]{partnerId, token, content});
        Map<String, String> uploadParams = this.getTemplateUploadParams(content);
        SmsTemplateUploadResp resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/templateUpload", uploadParams);
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return null;
            }
            resp = (SmsTemplateUploadResp)JSONObject.parseObject((String)data.toJSONString(), SmsTemplateUploadResp.class);
        }
        catch (Exception e) {
            log.error("templateUpload error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public List<SmsTemplateInfoResp> templateInfo(String partnerId, String token, List<String> templateIds) {
        log.info("templateInfo partnerId: {}, token: {}, templateIds:{}", new Object[]{partnerId, token, templateIds});
        Map<String, String> params = this.getTemplateInfoParams(templateIds);
        List templateDtos = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm/sms/templateInfo", params);
            JSONArray data = jsonObject.getJSONArray("data");
            if (data == null || data.isEmpty()) {
                log.info("get data is empty, templateIds:{}", templateIds);
                return null;
            }
            templateDtos = data.toJavaList(SmsTemplateInfoResp.class);
        }
        catch (Exception e) {
            log.error("templateInfo error", (Throwable)e);
        }
        return templateDtos;
    }

    private Map<String, String> getOpenParams(int unitPrice, String partnerId) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("unit_price", String.valueOf(unitPrice));
        result.put("partner_id", partnerId);
        result.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return result;
    }

    private Map<String, String> getCheckParams(String content) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(CONTENT, content);
        return map;
    }

    private Map<String, String> getNoticeSendParams(List<String> phones, String content, String signature) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put(SMS_SIGN, signature);
        params.put(CONTENT, content);
        params.put("to", String.join((CharSequence)",", phones));
        return params;
    }

    private Map<String, String> getSendParams(List<String> phones, String content, String bizNum, String signature) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CORP_ID, (Object)bizNum);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(SMS_SIGN, signature);
        map.put(CONTENT, content);
        map.put("type", "100003");
        map.put("to", String.join((CharSequence)",", phones));
        map.put("custom_params", jsonObject.toJSONString());
        return map;
    }

    private Map<String, String> getSendOneParams(String phone, String content, String bizNum, String signature) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(CORP_ID, (Object)bizNum);
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(SMS_SIGN, signature);
        map.put("type", "100003");
        map.put(CONTENT, content);
        map.put("to", phone);
        map.put("custom_params", jsonObject.toJSONString());
        return map;
    }

    private Map<String, String> getNoticeSendInfoParams(String bjyTaskId, String phone) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("msg_id", bjyTaskId);
        params.put("mobile", phone);
        return params;
    }

    private Map<String, String> getSendDetailParams(String bjyTaskId, int page, String partnerId) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("partner_id", partnerId);
        map.put(SEND_ID, bjyTaskId);
        map.put("page", String.valueOf(page));
        map.put("page_size", String.valueOf(100));
        map.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return map;
    }

    private Map<String, String> getTemplateUploadParams(String content) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put(CONTENT, content);
        return map;
    }

    private Map<String, String> getTemplateDeleteParams(List<String> templateIds) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("template_ids", StringUtils.join(templateIds, (String)","));
        return map;
    }

    private Map<String, String> getTemplateInfoParams(List<String> templateIds) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        map.put("template_ids", StringUtils.join(templateIds, (String)","));
        return map;
    }
}

