/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.exception.BusinessException;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractAutoSignAuthReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractCorpCertInfoReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractCustomerSignReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractFullUrlReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractGenerateReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractOpenReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractPersonInfoReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractRegisterReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractSignReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractTemplateEditReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractTemplateKeyReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractTemplateUploadReq;
import com.baijiayun.duanxunbao.sdk.dto.req.ContractVerifyUrlReq;
import com.baijiayun.duanxunbao.sdk.dto.resp.ContractAutoSignAuthResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.ContractGenerateResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.ContractSignResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.ContractTemplateKeyResp;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.baijiayun.duanxunbao.sdk.service.ContractService;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ContractServiceImpl
implements ContractService {
    private static final Logger log = LoggerFactory.getLogger(ContractServiceImpl.class);
    @Autowired
    private BjyPartnerService bjyPartnerService;

    @Override
    public ContractSignResp sign(String partnerId, String token, ContractSignReq req) {
        log.info("ContractSignResp partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.contractSign(req);
        ContractSignResp resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "/scrm_api/visa/contractSign", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return null;
            }
            resp = (ContractSignResp)JSONObject.parseObject((String)data.toJSONString(), ContractSignResp.class);
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public ContractGenerateResp generate(String partnerId, String token, ContractGenerateReq req) {
        log.info("generate partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.contractGenerate(req);
        ContractGenerateResp resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "/scrm_api/visa/generateContract", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return null;
            }
            resp = (ContractGenerateResp)JSONObject.parseObject((String)data.toJSONString(), ContractGenerateResp.class);
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public List<ContractTemplateKeyResp> getFddTemplateKeys(String partnerId, String token, ContractTemplateKeyReq req) {
        log.info("getFddTemplateKeys partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.contractTemplateKeys(req);
        List respList = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/getPdfTemplateKeys", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return null;
            }
            respList = JSONArray.parseArray((String)jsonObject.getString("data"), ContractTemplateKeyResp.class);
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return respList;
    }

    @Override
    public ContractAutoSignAuthResp autoSignAuthorize(String partnerId, String token, ContractAutoSignAuthReq req) {
        log.info("autoSignAuthorize partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.autoSignAuthorizeParam(req);
        ContractAutoSignAuthResp resp = new ContractAutoSignAuthResp();
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/beforeAuthSign", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty((Map)data)) {
                log.info("get data is empty");
                return null;
            }
            String url = jsonObject.getJSONObject("data").getString("url");
            resp.setUrl(url);
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public Object corpVerifyInfo(String partnerId, String token, ContractCorpCertInfoReq req) {
        log.info("corpVerifyInfo partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.corpVerifyInfoParam(req);
        JSONObject resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "/scrm_api/visa/companyCertInfo", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            resp = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public Object createCustomSignatureAndGetImgUrl(String partnerId, String token, ContractCustomerSignReq req) {
        log.info("createCustomSignatureAndGetImgUrl partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.createCustomSignatureAndGetImgUrlParam(req);
        JSONObject resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "/scrm_api/visa/customSignature", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528\u751f\u6210\u4f01\u4e1a\u5370\u7ae0\u63a5\u53e3\u5931\u8d25");
            }
            resp = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public Object contractOnlineEditUrl(String partnerId, String token, ContractTemplateEditReq req) {
        log.info("contractOnlineEditUrl partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.getContractTemplateEditUrlParam(req);
        JSONObject resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/getDocStream", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "bjyService \u63a5\u53e3\u8c03\u7528\u5f02\u5e38");
            }
            resp = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public Object contractOpen(String partnerId, String token, ContractOpenReq req) {
        log.info("contractOpen partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> map = this.getOpenParams(req);
        JSONObject resp = null;
        try {
            JSONObject jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/open", map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u5f00\u901a\u7535\u5b50\u5408\u540c\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
            }
            resp = jsonObject.getJSONObject("data");
        }
        catch (Exception e) {
            log.error("sign error", (Throwable)e);
        }
        return resp;
    }

    @Override
    public Object contractFullUrl(String partnerId, String token, ContractFullUrlReq req) {
        JSONObject jsonObject;
        log.info("contractFullUrl partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("path", req.getPath());
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/common/oss/getFullUrl", queryParams);
            log.info("getFullUrl result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u83b7\u53d6\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u83b7\u53d6\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u5931\u8d25");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u83b7\u53d6\u6587\u4ef6\u5b8c\u6574\u8def\u5f84\u5931\u8d25");
        }
        return jsonObject;
    }

    @Override
    public Object contractPersonCertInfo(String partnerId, String token, ContractPersonInfoReq req) {
        JSONObject jsonObject;
        log.info("contractPersonCertInfo partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> queryParams = this.contractPersonCertInfoParam(req);
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/personCertInfo", queryParams);
            log.info("getCustomerVerifyInfo result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            return "";
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528\u83b7\u53d6\u4e2a\u4eba\u5b9e\u540d\u8ba4\u8bc1\u4fe1\u606f\u63a5\u53e3\u5931\u8d25");
        }
        return jsonObject;
    }

    @Override
    public Object contractRegister(String partnerId, String token, ContractRegisterReq req) {
        JSONObject jsonObject;
        log.info("contractRegister partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> queryParams = this.contractRegisterParam(req);
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/accountRegister", queryParams);
            log.info("registerFddAccount result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u6ce8\u518c\u6cd5\u5927\u5927\u5e10\u53f7\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u6ce8\u518c\u5e10\u53f7\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return jsonObject;
    }

    @Override
    public Object contractTemplateUpload(String partnerId, String token, ContractTemplateUploadReq req) {
        JSONObject jsonObject;
        log.info("contractTemplateUpload partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> queryParams = this.contractTemplateUploadParam(req);
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/uploadTemplateDocs", queryParams);
            log.info("uploadTemplate2Fdd result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u4e0a\u4f20\u5408\u540c\u6a21\u677f\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528\u4e0a\u4f20\u5408\u540c\u6a21\u677f\u63a5\u53e3\u5931\u8d25");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u8c03\u7528\u4e0a\u4f20\u5408\u540c\u6a21\u677f\u63a5\u53e3\u5931\u8d25");
        }
        return null;
    }

    @Override
    public Object contractVerifyUrl(String partnerId, String token, ContractVerifyUrlReq req) {
        JSONObject jsonObject;
        log.info("contractVerifyUrl partnerId: {}, token: {},  req:{}", new Object[]{partnerId, token, req});
        Map<String, String> queryParams = this.contractVerifyUrlParam(req);
        try {
            jsonObject = this.bjyPartnerService.bjyPost(partnerId, token, "scrm_api/visa/accountVerifyUrl", queryParams);
            log.info("registerFddAccount result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u6ce8\u518c\u6cd5\u5927\u5927\u5e10\u53f7\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u83b7\u53d6\u5b9e\u540d\u8ba4\u8bc1\u5730\u5740\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return null;
    }

    private Map<String, String> contractSign(ContractSignReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("contract_id", req.getContractId());
        queryParams.put("doc_title", req.getDocTitle());
        queryParams.put("customer_id_a", req.getCorpCustomerId());
        queryParams.put("customer_id_b", req.getPersonCustomerId());
        queryParams.put("customer_name", req.getCustomerName());
        queryParams.put("customer_ident_no", req.getIdNo());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractGenerate(ContractGenerateReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("template_id", req.getTemplateId());
        queryParams.put("parameter_map", req.getParamMap());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractTemplateKeys(ContractTemplateKeyReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("template_id", req.getTemplateId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> autoSignAuthorizeParam(ContractAutoSignAuthReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> corpVerifyInfoParam(ContractCorpCertInfoReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("transaction_no", req.getTransactionNo());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> createCustomSignatureAndGetImgUrlParam(ContractCustomerSignReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("content", req.getCompanyName());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> getContractTemplateEditUrlParam(ContractTemplateEditReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("template_id", req.getTemplateId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> getOpenParams(ContractOpenReq req) {
        TreeMap<String, String> result = new TreeMap<String, String>();
        result.put("unit_price", String.valueOf(req.getUnitPrice()));
        result.put("verify_price", String.valueOf(req.getVerifyPrice()));
        result.put("partner_id", req.getPartnerId());
        result.put("callback_host", req.getCallbackHost());
        result.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return result;
    }

    private Map<String, String> contractPersonCertInfoParam(ContractPersonInfoReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("transaction_no", req.getTransactionNo());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractRegisterParam(ContractRegisterReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("open_id", req.getOpenId());
        queryParams.put("account_type", String.valueOf(req.getAccountType()));
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractTemplateUploadParam(ContractTemplateUploadReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("template_name", req.getTemplateName());
        queryParams.put("doc_url", req.getDocUrl());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractVerifyUrlParam(ContractVerifyUrlReq req) {
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }
}

