/*
 * Decompiled with CFR 0.152.
 */
package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.common.dto.ResultError;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.exception.BusinessException;
import com.baijiayun.duanxunbao.sdk.dto.req.AccountBaseReq;
import com.baijiayun.duanxunbao.sdk.dto.req.AccountBindReq;
import com.baijiayun.duanxunbao.sdk.dto.req.AccountConfigDto;
import com.baijiayun.duanxunbao.sdk.dto.req.AccountGetConfigReq;
import com.baijiayun.duanxunbao.sdk.dto.req.AccountLiveInfoReq;
import com.baijiayun.duanxunbao.sdk.dto.req.AccountProductOpenReq;
import com.baijiayun.duanxunbao.sdk.dto.req.AccountUpdateConfigReq;
import com.baijiayun.duanxunbao.sdk.dto.req.InitAccountReqDto;
import com.baijiayun.duanxunbao.sdk.dto.resp.AccountInfoResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.AccountProductResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.LiveInfoResp;
import com.baijiayun.duanxunbao.sdk.dto.resp.PartnerInfoRespDto;
import com.baijiayun.duanxunbao.sdk.dto.resp.TicketInfoResp;
import com.baijiayun.duanxunbao.sdk.service.AccountService;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger log = LoggerFactory.getLogger(AccountServiceImpl.class);
    @Autowired
    private BjyPartnerService bjyPartnerService;
    @Value(value="${app.bjy.privateDomainTemplate}")
    private String privateDomainTemplate;

    @Override
    public PartnerInfoRespDto bindAccount(AccountBindReq reqDto) {
        log.info("bindAccount reqDto: {}", (Object)reqDto);
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("corp_id", reqDto.getCorpId());
        params.put("corp_name", reqDto.getCorpName());
        params.put("phone", reqDto.getPhone());
        JSONObject account = this.bjyPartnerService.bjyPost("scrm/account/bind", params, (Map<String, String>)Maps.newHashMap()).getJSONObject("data");
        PartnerInfoRespDto respDto = new PartnerInfoRespDto();
        respDto.setPartnerId(account.getString("partner_id"));
        respDto.setPartnerKey(account.getString("partner_key"));
        respDto.setSecretKey(account.getString("secret_key"));
        respDto.setEmail(account.getString("email"));
        respDto.setMobile(account.getString("mobile"));
        respDto.setPartnerName(account.getString("partner_name"));
        respDto.setPrivateDomainUrl(account.getString("private_domain_url"));
        return respDto;
    }

    @Override
    public PartnerInfoRespDto isPhoneExist(String phone) {
        log.info("isPhoneExist phone:{}", (Object)phone);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)phone), (Object)"phone is blank");
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("phone", phone);
        JSONObject jsonObject = this.bjyPartnerService.bjyPost("scrm/account/isPhoneExist", params, (Map<String, String>)Maps.newHashMap());
        log.info("isPhoneExist get jsonObject: {}", (Object)jsonObject);
        PartnerInfoRespDto partnerInfoRespDto = new PartnerInfoRespDto();
        Integer exist = jsonObject.getJSONObject("data").getInteger("exist");
        Integer bind = jsonObject.getJSONObject("data").getInteger("bind");
        String mobile = jsonObject.getJSONObject("data").getString("phone");
        JSONObject partnerObj = jsonObject.getJSONObject("data").getJSONObject("partner");
        if (partnerObj != null) {
            String partnerId = partnerObj.getString("partner_id");
            String partnerKey = partnerObj.getString("partner_key");
            String secretKey = partnerObj.getString("secret_key");
            String email = partnerObj.getString("email");
            String partnerName = partnerObj.getString("partner_name");
            String domainUrl = partnerObj.getString("private_domain");
            partnerInfoRespDto.setPartnerId(partnerId);
            partnerInfoRespDto.setPartnerKey(partnerKey);
            partnerInfoRespDto.setSecretKey(secretKey);
            partnerInfoRespDto.setEmail(email);
            partnerInfoRespDto.setPartnerName(partnerName);
            partnerInfoRespDto.setPrivateDomainUrl(domainUrl);
        }
        partnerInfoRespDto.setExist(exist);
        partnerInfoRespDto.setBind(bind);
        partnerInfoRespDto.setMobile(mobile);
        return partnerInfoRespDto;
    }

    @Override
    public PartnerInfoRespDto getPrivateInfo(String partnerId) {
        log.info("getPartnerInfo partnerId:{}", (Object)partnerId);
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)partnerId), (Object)"partnerId is blank");
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("partner_id", partnerId);
        JSONObject jsonObject = this.bjyPartnerService.bjyPost("scrm/account/privateInfo", params, (Map<String, String>)Maps.newHashMap());
        log.info("getPartnerInfo jsonObject: {}", (Object)jsonObject);
        PartnerInfoRespDto partnerInfoRespDto = new PartnerInfoRespDto();
        Integer exist = jsonObject.getJSONObject("data").getInteger("exist");
        JSONObject partnerObj = jsonObject.getJSONObject("data").getJSONObject("partner");
        if (partnerObj != null) {
            String partnerKey = partnerObj.getString("partner_key");
            String secretKey = partnerObj.getString("secret_key");
            String email = partnerObj.getString("email");
            String partnerName = partnerObj.getString("partner_name");
            String domainUrl = partnerObj.getString("private_domain");
            String mobile = partnerObj.getString("phone");
            partnerInfoRespDto.setPartnerId(partnerId);
            partnerInfoRespDto.setPartnerKey(partnerKey);
            partnerInfoRespDto.setSecretKey(secretKey);
            partnerInfoRespDto.setEmail(email);
            partnerInfoRespDto.setPartnerName(partnerName);
            partnerInfoRespDto.setPrivateDomainUrl(domainUrl);
            partnerInfoRespDto.setMobile(mobile);
        }
        return partnerInfoRespDto;
    }

    @Override
    public int getAccountRestMoney(AccountBaseReq req) {
        JSONObject jsonObject;
        log.info("getAccountRestMoney, req:{}", (Object)req);
        TreeMap<String, String> queryParams = new TreeMap<String, String>();
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getPartnerId(), req.getToken(), "scrm_api/account/getBalance", queryParams);
            log.info("get restMoney result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("\u8c03\u7528\u83b7\u53d6\u5546\u6237\u4f59\u989d\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u83b7\u53d6\u5546\u6237\u53ef\u7528\u4f59\u989d\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "\u83b7\u53d6\u5546\u6237\u53ef\u7528\u4f59\u989d\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        return jsonObject.getJSONObject("data").getIntValue("left_total_money");
    }

    @Override
    public PartnerInfoRespDto createScrmAccount(String corpId, String corpName, String mobile) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("corp_id", corpId);
        params.put("corp_name", corpName);
        params.put("phone", mobile);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        JSONObject account = this.bjyPartnerService.bjyPost("scrm/account/create", params, (Map<String, String>)Maps.newHashMap()).getJSONObject("data");
        if (ObjectUtils.isEmpty((Object)account)) {
            return null;
        }
        PartnerInfoRespDto respDto = new PartnerInfoRespDto();
        respDto.setPartnerId(account.getString("partner_id"));
        respDto.setPartnerKey(account.getString("partner_key"));
        respDto.setSecretKey(account.getString("secret_key"));
        respDto.setEmail(account.getString("email"));
        respDto.setMobile(account.getString("mobile"));
        respDto.setPartnerName(account.getString("partner_name"));
        respDto.setPrivateDomainUrl(account.getString("private_domain_url"));
        return respDto;
    }

    @Override
    public String scrmLogin(String corpId) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("corp_id", corpId);
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        try {
            JSONObject result = this.bjyPartnerService.bjyPost("scrm/login", params, (Map<String, String>)Maps.newHashMap());
            log.info("getBjyToken params:{},result:{}", params, (Object)result);
            String token = result.getJSONObject("data").getString("token");
            return token;
        }
        catch (Exception e) {
            log.error("getBjyToken error", (Throwable)e);
            String token = "";
            return token;
        }
    }

    @Override
    public String dxbLogin(String partnerId) {
        TreeMap<String, String> params = new TreeMap<String, String>();
        params.put("partner_id", partnerId);
        params.put("app_from", "dxb");
        params.put("timestamp", String.valueOf(System.currentTimeMillis()));
        log.info("dxbLogin get params: {}", params);
        try {
            JSONObject result = this.bjyPartnerService.bjyPost("scrm/login/v2", params, (Map<String, String>)Maps.newHashMap());
            log.info("dxbLogin params:{},result:{}", params, (Object)result);
            String token = result.getJSONObject("data").getString("token");
            return token;
        }
        catch (Exception e) {
            log.error("dxbLogin error", (Throwable)e);
            String token = "";
            return token;
        }
    }

    @Override
    public String scrmAccountConfig(AccountConfigDto dto) {
        log.info("scrmAccountConfig dto: {}", (Object)dto);
        HashMap param = Maps.newHashMap();
        param.put("live_chat_keywork_callback_url", dto.getKeywordCallBackUrl());
        param.put("enable_live_chat_keyword", dto.getEnableLiveKeyword());
        param.put("enable_user_event_callback", dto.getEnableUserEvent());
        param.put("user_event_callback_url", dto.getUserEventCallBackUrl());
        param.put("enable_live_sell_pc_student", dto.getEnableLiveSellPc());
        param.put("enable_use_lucky_bag", dto.getEnableUserLuckyBug());
        JSONObject response = this.bjyPartnerService.bjyPost(dto.getPartnerId(), dto.getToken(), "scrm/account/config", param);
        HashMap result = Maps.newHashMap();
        result.put("param", JSON.toJSONString((Object)param));
        result.put("response", JSON.toJSONString((Object)response));
        result.put("url", "scrm/account/config");
        return JSON.toJSONString((Object)result);
    }

    @Override
    public String initAccount(InitAccountReqDto reqDto) {
        HashMap param = Maps.newHashMap();
        param.put("user_event_callback_url", reqDto.getUserEventCallbackUrl());
        param.put("live_award_callback_url", reqDto.getLiveAwardCallbackUrl());
        param.put("live_chat_keyword_callback_url", reqDto.getLiveChatKeyworkCallbackUrl());
        param.put("live_room_callback_url", reqDto.getLiveRoomCallbackUrl());
        param.put("chat_message_callback_url", reqDto.getChatMessageCallbackUrl());
        param.put("live_operator_callback_url", reqDto.getLiveOperatorCallbackUrl());
        param.put("live_room_signal_push_callback_url", reqDto.getLiveSignalCallBackUrl());
        param.put("transcode_callback_url", reqDto.getLiveTranscodeCallbackUrl());
        log.info("initAccount param: {}", (Object)param);
        JSONObject response = this.bjyPartnerService.bjyPost(reqDto.getPartnerId(), reqDto.getToken(), "scrm/account/initAccount", param);
        HashMap result = Maps.newHashMap();
        result.put("param", JSON.toJSONString((Object)param));
        result.put("response", JSON.toJSONString((Object)response));
        result.put("url", "scrm/account/initAccount");
        return JSON.toJSONString((Object)result);
    }

    @Override
    public AccountProductResp accountProduct(AccountBaseReq req) {
        JSONObject jsonObject;
        log.info("accountProduct reqDto: {}", (Object)req);
        HashMap queryParams = Maps.newHashMap();
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getPartnerId(), req.getToken(), "scrm/account/getProduct", queryParams);
            log.info("accountProduct result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("accountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "accountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "accountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        JSONArray product = jsonObject.getJSONObject("data").getJSONArray("product");
        List productList = product.toJavaList(Integer.class);
        log.info("accountProduct product: {}, productList: {}", (Object)product, (Object)productList);
        AccountProductResp resp = new AccountProductResp();
        resp.setProduct(productList);
        return resp;
    }

    @Override
    public AccountProductResp openAccountProduct(AccountProductOpenReq req) {
        JSONObject jsonObject;
        log.info("openAccountProduct reqDto: {}", (Object)req);
        HashMap openParams = Maps.newHashMap();
        openParams.put("product_type", String.valueOf(req.getProductType()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getPartnerId(), req.getToken(), "scrm/account/openProduct", openParams);
            log.info("openAccountProduct result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        Boolean isOpen = jsonObject.getBoolean("data");
        log.info("openAccountProduct isOpen: {}", (Object)isOpen);
        AccountProductResp resp = new AccountProductResp();
        resp.setIsOpen(isOpen);
        return resp;
    }

    @Override
    public TicketInfoResp getTicketInfo(String ticket) {
        JSONObject jsonObject;
        log.info("getTicketInfo ticket: {}", (Object)ticket);
        HashMap params = Maps.newHashMap();
        params.put("ticket", ticket);
        try {
            jsonObject = this.bjyPartnerService.bjyPostByOpenApi("ticketInfo", params);
            log.info("getTicketInfo result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("getTicketInfo \u8c03\u7528\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "getTicketInfo \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "getTicketInfo \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        JSONObject data = jsonObject.getJSONObject("data");
        if (ObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        TicketInfoResp ticketInfoResp = (TicketInfoResp)JSONObject.parseObject((String)data.toJSONString(), TicketInfoResp.class);
        if (ticketInfoResp != null && StringUtils.isNotBlank((CharSequence)ticketInfoResp.getPrivateDomain())) {
            ticketInfoResp.setFullPrivateDomain(MessageFormat.format(this.privateDomainTemplate, ticketInfoResp.getPrivateDomain()));
        }
        return ticketInfoResp;
    }

    @Override
    public LiveInfoResp queryRoomInfo(AccountLiveInfoReq req) {
        JSONObject jsonObject;
        log.info("queryRoomInfo req: {}", (Object)req);
        HashMap params = Maps.newHashMap();
        params.put("room_id", String.valueOf(req.getRoomId()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getPartnerId(), req.getToken(), "scrm/room/info", params);
            log.info("queryRoomInfo result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("queryRoomInfo \u8c03\u7528\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        JSONObject data = jsonObject.getJSONObject("data");
        if (ObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        return (LiveInfoResp)JSONObject.parseObject((String)data.toJSONString(), LiveInfoResp.class);
    }

    @Override
    public JSONObject getAccountConfig(AccountGetConfigReq req) {
        JSONObject jsonObject;
        log.info("getAccountConfig req: {}", (Object)req);
        HashMap params = Maps.newHashMap();
        params.put("keys", String.valueOf(req.getKey()));
        params.put("product_type", String.valueOf(req.getProductType()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getPartnerId(), req.getToken(), "/scrm/partner/getConfigs", params);
            log.info("getAccountConfig result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("getAccountConfig \u8c03\u7528\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25:" + msg);
        }
        JSONObject data = jsonObject.getJSONObject("data");
        if (ObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        return data;
    }

    @Override
    public void updateAccountConfig(AccountUpdateConfigReq req) {
        JSONObject jsonObject;
        log.info("updateAccountConfig req: {}", (Object)req);
        HashMap params = Maps.newHashMap();
        params.put("key", String.valueOf(req.getKey()));
        params.put("product_type", String.valueOf(req.getProductType()));
        params.put("value", String.valueOf(req.getValue()));
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getPartnerId(), req.getToken(), "/scrm/partner/updateConfig", params);
            log.info("updateAccountConfig result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("updateAccountConfig \u8c03\u7528\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "updateAccountConfig \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "openAccountProduct \u8c03\u7528\u63a5\u53e3\u5931\u8d25:" + msg);
        }
    }

    @Override
    public AccountInfoResp getAccountInfo(AccountBaseReq req) {
        JSONObject jsonObject;
        log.info("getAccountInfo req: {}", (Object)req);
        HashMap queryParams = Maps.newHashMap();
        try {
            jsonObject = this.bjyPartnerService.bjyPost(req.getPartnerId(), req.getToken(), "scrm/account/getAccountInfo", queryParams);
            log.info("getAccountInfo result:{}", (Object)jsonObject);
        }
        catch (Exception ex) {
            log.error("getAccountInfo \u8c03\u7528\u63a5\u53e3\u5931\u8d25:", (Throwable)ex);
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "getAccountInfo \u8c03\u7528\u63a5\u53e3\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
        }
        int code = jsonObject.getIntValue("code");
        String msg = jsonObject.getString("msg");
        if (code != 0) {
            throw new BusinessException((ResultError)ResultCode.BUSINESS_ERROR, "getAccountInfo \u8c03\u7528\u63a5\u53e3\u5931\u8d25:" + msg);
        }
        JSONObject data = jsonObject.getJSONObject("data");
        if (ObjectUtils.isEmpty((Object)data)) {
            return null;
        }
        return (AccountInfoResp)JSONObject.parseObject((String)data.toJSONString(), AccountInfoResp.class);
    }
}

