package com.baijiayun.duanxunbao.sdk.utils;

import com.baijiayun.duanxunbao.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

public enum VoiceMaterialTypeEnum implements EnumService {
    /**
     * 文本
     */
    TEXT(1, "文本"),
    VOICE(2, "语音");

    private final int value;
    private final String name;

    VoiceMaterialTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, VoiceMaterialTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (VoiceMaterialTypeEnum item : VoiceMaterialTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static VoiceMaterialTypeEnum get(Integer value) {
        return CACHE.get(value);
    }
}
