package com.baijiayun.duanxunbao.sdk.utils;

import com.baijiayun.duanxunbao.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

public enum LiveProductTypeEnum implements EnumService {

    BIG_CLASS(1, "大班课"),
    SMALL_CLASS(2, "小班课"),
    WEWORK_LIVE(3, "企业直播"),
    CLICK_LIVE(4, "点播")
    ;


    private final int value;
    private final String name;

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }


    LiveProductTypeEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    private static final Map<Integer, LiveProductTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (LiveProductTypeEnum item : LiveProductTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static LiveProductTypeEnum get(Integer value) {
        return CACHE.get(value);
    }
}
