package com.baijiayun.duanxunbao.sdk.utils;

import com.baijiayun.duanxunbao.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

public enum ApiTypeEnum implements EnumService {
    LOCAL(0, "local", "双呼回显"),
    AT_TABLE(1, "exten", "坐席"),
    LOCAL_WEB(2, "local_web", "容联直连"),
    SIP(3, "sip", "网络电话"),
    VOICE(4, "voice", "语音外呼");

    private int value;
    private String name;
    private String desc;

    ApiTypeEnum(int value, String name, String desc) {
        this.value = value;
        this.name = name;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    public String getName() {
        return name;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, ApiTypeEnum> cache;

    static {
        cache = new HashMap<>();
        for (ApiTypeEnum item : ApiTypeEnum.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static ApiTypeEnum get(Integer value) {
        return cache.get(value);
    }

    public static int ofValue(String name) {
        for (ApiTypeEnum item : ApiTypeEnum.values()) {
            if (item.getName().equals(name)) {
                return item.getValue();
            }
        }
        return 0;
    }
}