package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.baijiayun.duanxunbao.sdk.service.ScrmOpenUrl;
import com.baijiayun.duanxunbao.sdk.service.WalletService;
import com.google.common.base.Joiner;
import lombok.extern.slf4j.Slf4j;
import org.apache.poi.hssf.usermodel.*;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.*;
import java.util.Map.Entry;

@Slf4j
@Service
public class WalletServiceImpl implements WalletService {

    @Autowired
    private BjyPartnerService bjyPartnerService;

    @Override
    public Object partnerInfoList(String partnerId, String token, List<String> partnerIds) {
        log.info("partnerInfoList partnerId: {}, token: {},  partnerIds:{}", partnerId, token, partnerIds);
        if (CollectionUtils.isEmpty(partnerIds)) {
            return null;
        }
        String partnerStr = Joiner.on(",").join(partnerIds);
        Map<String, String> params = new HashMap<>();
        params.put("partner_ids", partnerStr);
        return bjyPartnerService.bjyPost(ScrmOpenUrl.WALLET_ACCOUNT_BATCH_URL, params, null);
    }

    @Override
    public Object accountInfo(String partnerId, String token, Map<String, String> map) {
        log.info("accountInfo partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_ACCOUNT_INFO, map);
    }

    @Override
    public Object wxPayQrcode(String partnerId, String token, Map<String, String> map) {
        log.info("wxPayQrcode partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_WX_PAY_QRCODE, map);
    }

    @Override
    public Object getPayStatus(String partnerId, String token, Map<String, String> map) {
        log.info("getPayStatus partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_PAY_STATUS, map);
    }

    @Override
    public Object payOffline(String partnerId, String token, Map<String, String> map) {
        log.info("payOffline partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_PAY_OFFLINE, map);
    }

    @Override
    public Object consumeStatisticsByMonth(String partnerId, String token, Map<String, String> map) {
        log.info("consumeStatisticsByMonth partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_CONSUME_STATISTICS_MOUTH, map);
    }

    @Override
    public Object getBankVirtualAccount(String partnerId, String token, Map<String, String> map) {
        log.info("getBankVirtualAccount partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_BANK_VIRTUAL_ACCOUNT, map);
    }

    @Override
    public void exprotConsumeStatisticsByMonth(String partnerId, String token, Map<String, String> map, HttpServletResponse response) {
        log.info("exprotConsumeStatisticsByMonth partnerId: {}, token: {},  map:{}", partnerId, token, map);
        map.put("render", "json");
        JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_EXPORT_CONSUMER_STATISTICS_MOUTH, map);
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List<Map<String, String>> dataList = JSONArray.parseObject(list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        export(header, dataList, data.getString("title"), "消费记录", response);
    }

    @Override
    public Object getRevenueList(String partnerId, String token, Map<String, String> map) {
        log.info("getRevenueList partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_REVENUE_LIST, map);
    }

    @Override
    public void exportRevenueList(String partnerId, String token, Map<String, String> map, HttpServletResponse response) {
        log.info("exportRevenueList partnerId: {}, token: {},  map:{}", partnerId, token, map);
        map.put("render", "json");
        JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_EXPORT_REVENUE_LIST, map);
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List<Map<String, String>> dataList = JSONArray.parseObject(list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        export(header, dataList, data.getString("title"), "收支明细", response);
    }

    @Override
    public Object getBillList(String partnerId, String token, Map<String, String> map) {
        log.info("getBillList partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_BILL_LIST, map);
    }

    @Override
    public void exportBillList(String partnerId, String token, Map<String, String> map, HttpServletResponse response) {
        log.info("exportBillList partnerId: {}, token: {},  map:{}", partnerId, token, map);
        map.put("render", "json");
        JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_EXPORT_BILL_LIST, map);
        JSONObject data = jsonObject.getJSONObject("data");
        JSONArray list = data.getJSONArray("list");
        List<Map<String, String>> dataList = JSONArray.parseObject(list.toJSONString(), List.class);
        JSONObject header = data.getJSONObject("header");
        export(header, dataList, data.getString("title"), "账单费用", response);
    }

    @Override
    public Object getConfirmationList(String partnerId, String token, Map<String, String> map) {
        log.info("getConfirmationList partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_CONFIRMATION_LIST, map);
    }

    @Override
    public Object confirm(String partnerId, String token, Map<String, String> map) {
        log.info("confirm partnerId: {}, token: {},  map:{}", partnerId, token, map);
        return bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.WALLET_CONFIRM, map);
    }

    private void export(JSONObject heads, List<Map<String, String>> data, String title, String sheetName, HttpServletResponse response) {
        if (CollectionUtils.isEmpty(heads)) {
            return;
        }
        HSSFWorkbook workbook = new HSSFWorkbook();
        HSSFSheet sheet = workbook.createSheet(sheetName);
        //设置要导出的文件的名字
        HSSFRow row = sheet.createRow(0);
        row.setZeroHeight(false);
        row.setHeight((short) (18 * 20));

        HSSFCellStyle headerCellStyle = workbook.createCellStyle();
        headerCellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
        headerCellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);

        Font headerFont = workbook.createFont();
        headerFont.setBold(true);
        headerFont.setFontHeightInPoints((short) 12);
        headerCellStyle.setFont(headerFont);

        int size = heads.size();
        String[] headers = new String[size];
        List<String> fields = new ArrayList<>(size);
        int headIndex = 0;
        for (Entry<String, Object> head : heads.entrySet()) {
            headers[headIndex] = String.valueOf(head.getValue());
            fields.add(String.valueOf(head.getKey()));
            headIndex++;
        }

        //在excel表中添加表头
        for (int i = 0; i < headers.length; i++) {
            sheet.setColumnWidth(i, 25 * 256);
            HSSFCell cell = row.createCell(i);
            cell.setCellStyle(headerCellStyle);
            HSSFRichTextString text = new HSSFRichTextString(headers[i]);
            cell.setCellValue(text);
        }

        if (!CollectionUtils.isEmpty(data)) {
            //在表中存放查询到的数据放入对应的列
            int rowNum = 1;
            for (Map<String, String> map : data) {
                HSSFRow ssRow = sheet.createRow(rowNum);
                createAndSetCell(ssRow, map, fields);
                rowNum++;
            }
        }
        try {
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(title, "UTF-8"));
            response.setHeader("content-Type", "application/vnd.ms-excel");
            response.flushBuffer();
            workbook.write(response.getOutputStream());
        } catch (IOException e) {
            log.error("保存excel失败", e);
        }
    }

    private void createAndSetCell(HSSFRow ssRow, Map<String, String> map, List<String> fields) {
        for (int i = 0; i < fields.size(); i++) {
            ssRow.createCell(i).setCellValue(String.valueOf(map.get(fields.get(i))));
        }
    }
}
