package com.baijiayun.duanxunbao.sdk.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.common.enums.ResultCode;
import com.baijiayun.duanxunbao.common.exception.BusinessException;
import com.baijiayun.duanxunbao.sdk.dto.req.*;
import com.baijiayun.duanxunbao.sdk.dto.resp.*;
import com.baijiayun.duanxunbao.sdk.service.BjyPartnerService;
import com.baijiayun.duanxunbao.sdk.service.ContractService;
import com.baijiayun.duanxunbao.sdk.service.ScrmOpenUrl;
import joptsimple.internal.Strings;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;

@Slf4j
@Service
public class ContractServiceImpl implements ContractService {

    @Autowired
    private BjyPartnerService bjyPartnerService;


    @Override
    public ContractSignResp sign(String partnerId, String token, ContractSignReq req) {
        log.info("ContractSignResp partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = contractSign(req);
        ContractSignResp resp = null;
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_SIGN, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "bjyService 接口调用异常");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty(data)) {
                log.info("get data is empty");
                return null;
            }
            resp = JSONObject.parseObject(data.toJSONString(), ContractSignResp.class);
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return resp;
    }

    @Override
    public ContractGenerateResp generate(String partnerId, String token, ContractGenerateReq req) {
        log.info("generate partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = contractGenerate(req);
        ContractGenerateResp resp = null;
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_GENERATE, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "bjyService 接口调用异常");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty(data)) {
                log.info("get data is empty");
                return null;
            }
            resp = JSONObject.parseObject(data.toJSONString(), ContractGenerateResp.class);
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return resp;
    }

    @Override
    public List<ContractTemplateKeyResp> getFddTemplateKeys(String partnerId, String token, ContractTemplateKeyReq req) {
        log.info("getFddTemplateKeys partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = contractTemplateKeys(req);
        List<ContractTemplateKeyResp> respList = null;
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_TEMPLATE_KEY, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "bjyService 接口调用异常");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty(data)) {
                log.info("get data is empty");
                return null;
            }
            respList = JSONArray.parseArray(jsonObject.getString("data"), ContractTemplateKeyResp.class);
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return respList;
    }

    @Override
    public ContractAutoSignAuthResp autoSignAuthorize(String partnerId, String token, ContractAutoSignAuthReq req) {
        log.info("autoSignAuthorize partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = autoSignAuthorizeParam(req);
        ContractAutoSignAuthResp resp = new ContractAutoSignAuthResp();
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_AUTO_AUTH_SIGN, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "bjyService 接口调用异常");
            }
            JSONObject data = jsonObject.getJSONObject("data");
            if (MapUtils.isEmpty(data)) {
                log.info("get data is empty");
                return null;
            }
            String url = jsonObject.getJSONObject("data").getString("url");
            resp.setUrl(url);
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return resp;
    }

    @Override
    public Object corpVerifyInfo(String partnerId, String token, ContractCorpCertInfoReq req) {
        log.info("corpVerifyInfo partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = corpVerifyInfoParam(req);
        Object resp = null;
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_CORP_CERT_INFO, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "bjyService 接口调用异常");
            }
            resp = jsonObject.getJSONObject("data");
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return resp;
    }

    @Override
    public Object createCustomSignatureAndGetImgUrl(String partnerId, String token, ContractCustomerSignReq req) {
        log.info("createCustomSignatureAndGetImgUrl partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = createCustomSignatureAndGetImgUrlParam(req);
        Object resp = null;
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_CUSTOM_SIGN, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "调用生成企业印章接口失败");
            }
            resp = jsonObject.getJSONObject("data");
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return resp;
    }

    @Override
    public Object contractOnlineEditUrl(String partnerId, String token, ContractTemplateEditReq req) {
        log.info("contractOnlineEditUrl partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = getContractTemplateEditUrlParam(req);
        Object resp = null;
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_ONLINE_EDIT, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "bjyService 接口调用异常");
            }
            resp = jsonObject.getJSONObject("data");
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return resp;
    }

    @Override
    public Object contractOpen(String partnerId, String token, ContractOpenReq req) {
        log.info("contractOpen partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> map = getOpenParams(req);
        Object resp = null;
        try {
            JSONObject jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_OPEN, map);
            int code = jsonObject.getIntValue("code");
            if (code != 0) {
                throw new BusinessException(ResultCode.BUSINESS_ERROR, "开通电子合同失败,请稍后重试");
            }
            resp = jsonObject.getJSONObject("data");
        } catch (Exception e) {
            log.error("sign error", e);
        }
        return resp;
    }

    @Override
    public Object contractFullUrl(String partnerId, String token,ContractFullUrlReq req) {
        log.info("contractFullUrl partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("path", req.getPath());

        JSONObject jsonObject;
        try {
            jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_OSS_FULL_URL, queryParams);
            log.info("getFullUrl result:{}", jsonObject);
        } catch (Exception ex) {
            log.error("获取文件完整路径失败:", ex);
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "获取文件完整路径失败");
        }

        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "获取文件完整路径失败");
        }
        return jsonObject;
    }

    @Override
    public Object contractPersonCertInfo(String partnerId, String token, ContractPersonInfoReq req) {
        log.info("contractPersonCertInfo partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> queryParams = contractPersonCertInfoParam(req);
        JSONObject jsonObject;
        try {
            jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_PERSON_CERT_INFO, queryParams);
            log.info("getCustomerVerifyInfo result:{}", jsonObject);
        } catch (Exception ex) {
            log.error("调用获取个人实名认证信息接口失败:", ex);
            return Strings.EMPTY;
        }
        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "调用获取个人实名认证信息接口失败");
        }

        return jsonObject;
    }

    @Override
    public Object contractRegister(String partnerId, String token, ContractRegisterReq req) {
        log.info("contractRegister partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> queryParams = contractRegisterParam(req);
        JSONObject jsonObject;
        try {
            jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_REGISTER, queryParams);
            log.info("registerFddAccount result:{}", jsonObject);
        } catch (Exception ex) {
            log.error("调用注册法大大帐号接口失败:", ex);
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "注册帐号失败,请稍后重试");
        }

        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "获取实名认证地址失败,请稍后重试");
        }
        return jsonObject;
    }

    @Override
    public Object contractTemplateUpload(String partnerId, String token,ContractTemplateUploadReq req) {
        log.info("contractTemplateUpload partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> queryParams = contractTemplateUploadParam(req);
        JSONObject jsonObject;
        try {
            jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_TEMPLATE_UPLOAD, queryParams);
            log.info("uploadTemplate2Fdd result:{}", jsonObject);
        } catch (Exception ex) {
            log.error("调用上传合同模板接口失败:", ex);
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "调用上传合同模板接口失败");
        }

        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "调用上传合同模板接口失败");
        }
        return null;
    }

    @Override
    public Object contractVerifyUrl(String partnerId, String token, ContractVerifyUrlReq req) {
        log.info("contractVerifyUrl partnerId: {}, token: {},  req:{}", partnerId, token, req);
        Map<String, String> queryParams = contractVerifyUrlParam(req);
        JSONObject jsonObject;
        try {
            jsonObject = bjyPartnerService.bjyPost(partnerId, token, ScrmOpenUrl.CONTRACT_VERIFY, queryParams);
            log.info("registerFddAccount result:{}", jsonObject);
        } catch (Exception ex) {
            log.error("调用注册法大大帐号接口失败:", ex);
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "获取实名认证地址失败,请稍后重试");
        }

        int code = jsonObject.getIntValue("code");
        if (code != 0) {
            throw new BusinessException(ResultCode.BUSINESS_ERROR, "获取实名认证地址失败,请稍后重试");
        }
        return null;
    }


    private Map<String, String> contractSign(ContractSignReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("contract_id", req.getContractId());
        queryParams.put("doc_title", req.getDocTitle());
        queryParams.put("customer_id_a", req.getCorpCustomerId());
        queryParams.put("customer_id_b", req.getPersonCustomerId());
        queryParams.put("customer_name", req.getCustomerName());
        queryParams.put("customer_ident_no", req.getIdNo());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractGenerate(ContractGenerateReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("template_id", req.getTemplateId());
        queryParams.put("parameter_map", req.getParamMap());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractTemplateKeys(ContractTemplateKeyReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("template_id", req.getTemplateId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> autoSignAuthorizeParam(ContractAutoSignAuthReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> corpVerifyInfoParam(ContractCorpCertInfoReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("transaction_no", req.getTransactionNo());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> createCustomSignatureAndGetImgUrlParam(ContractCustomerSignReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("content", req.getCompanyName());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> getContractTemplateEditUrlParam(ContractTemplateEditReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("template_id", req.getTemplateId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> getOpenParams(ContractOpenReq req) {
        Map<String, String> result = new TreeMap<>();
        result.put("unit_price", String.valueOf(req.getUnitPrice()));
        result.put("verify_price", String.valueOf(req.getVerifyPrice()));
        result.put("partner_id", req.getPartnerId());
        result.put("callback_host", req.getCallbackHost());
        result.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return result;
    }

    private Map<String, String> contractPersonCertInfoParam(ContractPersonInfoReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("transaction_no", req.getTransactionNo());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractRegisterParam(ContractRegisterReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("open_id", req.getOpenId());
        queryParams.put("account_type", String.valueOf(req.getAccountType()));
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractTemplateUploadParam(ContractTemplateUploadReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("template_name", req.getTemplateName());
        queryParams.put("doc_url", req.getDocUrl());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }

    private Map<String, String> contractVerifyUrlParam(ContractVerifyUrlReq req) {
        Map<String, String> queryParams = new TreeMap<>();
        queryParams.put("customer_id", req.getCustomerId());
        queryParams.put("partner_id", req.getPartnerId());
        queryParams.put("timestamp", String.valueOf(System.currentTimeMillis()));
        return queryParams;
    }
}
