package com.baijiayun.duanxunbao.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.sdk.dto.req.*;
import com.baijiayun.duanxunbao.sdk.dto.resp.*;

import java.util.List;

public interface SmsService {

    /**
     *  ${app.sms.checkUrl}
     * */
    SmsCheckUrlResp checkUrl(String partnerId, String token, String content);

    /**
     *  ${app.sms.noticeSendInfoUrl}
     * */
    SmsSendDetail noticeSendInfo(String partnerId, String token, SmsNoticeSendInfoReq req);

    /**
     *  ${app.sms.noticeSendUrl}
     * */
    JSONObject noticeSend(String partnerId, String token, SmsNoticeSendReq req);

    /**
     *  ${app.sms.openUrl}
     * */
    JSONObject open(String partnerId, String token, SmsOpenReq req);

    /**
     *  ${app.sms.sendDetailUrl}
     * */
    JSONObject sendDetail(String partnerId, String token, SmsSendDetailReq req);

    /**
     *  ${app.sms.sendUrl}
     * */
    SmsSendResp send(String partnerId, String token, SmsSendReq req);

    /**
     *  ${app.sms.templateDeleteUrl}
     * */
    void templateDelete(String partnerId, String token, List<String> templateIds);

    /**
     *  ${app.sms.templateUploadUrl}
     * */
    SmsTemplateUploadResp templateUpload(String partnerId, String token, String content);

    /**
     *  ${app.sms.templateInfoUrl}
     * */
    List<SmsTemplateInfoResp> templateInfo(String partnerId, String token, List<String> templateIds);
}
