package com.baijiayun.duanxunbao.sdk.service;

import com.baijiayun.duanxunbao.sdk.dto.req.*;
import com.baijiayun.duanxunbao.sdk.dto.resp.*;

import java.util.List;

public interface ContractService {

    /**
     *  ${app.center.contractSignUrl}
     *
     * */
    ContractSignResp sign(String partnerId, String token, ContractSignReq req);

    /**
     *  ${app.center.generateContractUrl}
     * */
    ContractGenerateResp generate(String partnerId, String token, ContractGenerateReq req);

    /**
     *  ${app.center.getTemplateKeysUrl}
     * */
    List<ContractTemplateKeyResp> getFddTemplateKeys(String partnerId, String token, ContractTemplateKeyReq req);

    /**
     *  ${app.contract.autoSignAuthorizeUrl}
     * */
    ContractAutoSignAuthResp autoSignAuthorize(String partnerId, String token, ContractAutoSignAuthReq req);

    /**
     *  ${app.contract.corpCertInfoUrl}
     * */
    Object corpVerifyInfo(String partnerId, String token, ContractCorpCertInfoReq req);

    /**
     *  ${app.contract.createSignatureUrl}
     * */
    Object createCustomSignatureAndGetImgUrl(String partnerId, String token, ContractCustomerSignReq req);

    /**
     *  ${app.contract.onlineEditUrl}
     * */
    Object contractOnlineEditUrl(String partnerId, String token, ContractTemplateEditReq req);

    /**
     *  ${app.contract.openUrl}
     * */
    Object contractOpen(String partnerId, String token, ContractOpenReq req);

    /**
     *  ${app.contract.ossFullUrl}
     * */
    Object contractFullUrl(String partnerId, String token, ContractFullUrlReq req);

    /**
     *  ${app.contract.personCertInfoUrl}
     * */
    Object contractPersonCertInfo(String partnerId, String token, ContractPersonInfoReq req);

    /**
     *  ${app.contract.registerUrl}
     * */
    Object contractRegister(String partnerId, String token, ContractRegisterReq req);

    /**
     *  ${app.contract.uploadTemplateUrl}
     * */
    Object contractTemplateUpload(String partnerId, String token, ContractTemplateUploadReq req);

    /**
     *  ${app.contract.verifyUrl}
     * */
    Object contractVerifyUrl(String partnerId, String token, ContractVerifyUrlReq req);
}
