package com.baijiayun.duanxunbao.sdk.service;

import com.alibaba.fastjson.JSONObject;

import java.util.Map;

/**
 * @author lanye
 */
public interface BjyPartnerService {

    /**
     * 设置sign
     *
     * @param params
     */
    void setSign(Map<String, String> params);

    /**
     * 获取token
     *
     * @param url
     * @param params
     * @param header
     * @return
     */
    JSONObject bjyPost(String url, Map<String, String> params, Map<String, String> header);

    /**
     * 获取发起请求
     *
     * @param url
     * @param params
     * @return
     */
    JSONObject bjyPost(String partnerId, String token, String url, Map<String, String> params);

    JSONObject bjyPost(String partnerId, String url, Map<String, String> params);

    /**
     * 根据ip获取城市
     *
     * @param ip
     * @return
     */
    String getCityByIp(String ip);

    /**
     * 通过百家云openApi的对接方式调用百家云接口
     * @param url
     * @param params
     * @return
     */
    JSONObject bjyPostByOpenApi(String url, Map<String, String> params);

}
