package com.baijiayun.duanxunbao.sdk.service;

import com.alibaba.fastjson.JSONObject;
import com.baijiayun.duanxunbao.sdk.dto.req.*;
import com.baijiayun.duanxunbao.sdk.dto.resp.*;

public interface AccountService {

    @Deprecated
    PartnerInfoRespDto bindAccount(AccountBindReq reqDto);

    /**
     * 账号信息
     */
    PartnerInfoRespDto isPhoneExist(String phone);

    PartnerInfoRespDto getPrivateInfo(String partnerId);

    int getAccountRestMoney(AccountBaseReq req);

    /**
     * 开通百家云账号
     *
     */
    PartnerInfoRespDto createScrmAccount(String corpId, String corpName, String mobile);

    /**
     *  getToken
     * */
    @Deprecated
    String scrmLogin(String corpId);

    /**
     * 短训宝登录获取token
     * */
    String dxbLogin(String partnerId);


    String scrmAccountConfig(AccountConfigDto dto);

    /**
     *  百家云直播账号 回调地址初始化
     * */
    String initAccount(InitAccountReqDto reqDto);


    /**
     *  已开通的产品线
     * */
    AccountProductResp accountProduct(AccountBaseReq req);

    /**
     *  开通的产品线
     * */
    AccountProductResp openAccountProduct(AccountProductOpenReq req);

    /**
     * https://ewiki.baijiashilian.com/%E7%99%BE%E5%AE%B6%E4%BA%91/%E7%BB%9F%E4%B8%80%E7%99%BB%E5%BD%95/%E7%BB%9F%E4%B8%80%E7%99%BB%E5%BD%95.md#api-1-%E4%BB%A4%E7%89%8C%E8%8E%B7%E5%8F%96%E5%AE%A2%E6%88%B7%E4%BF%A1%E6%81%AF
     * 获取账户信息
     * @param ticket
     * @return
     */
    TicketInfoResp getTicketInfo(String ticket);


    /**
     *  查询直播间信息
     *  内部接口
     * */
    LiveInfoResp queryRoomInfo(AccountLiveInfoReq req);

    /**
     *  获取账号配置
     * */
    JSONObject getAccountConfig(AccountGetConfigReq req);

    void updateAccountConfig(AccountUpdateConfigReq req);


    AccountInfoResp getAccountInfo(AccountBaseReq req);
}
