package com.baijiayun.duanxunbao.sdk.dto.resp;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class LiveInfoResp implements Serializable {


    @JsonProperty("room_id")
    private String roomId;

    private String title;

    @JsonProperty("start_time")
    private String startTime;

    @JsonProperty("end_time")
    private String endTime;

    @JsonProperty("create_time")
    private String createTime;

    private Integer type;

    @JsonProperty("pre_enter_time")
    private Integer preEnterTime;

    /**
     * 是否是长期房间
     */
    @JsonProperty("is_long_term")
    private Integer isLongTerm;

    @JsonProperty("max_users")
    private Integer maxUsers;

    @JsonProperty("admin_code")
    private String adminCode;

    @JsonProperty("teacher_code")
    private String teacherCode;

    @JsonProperty("user_code")
    private String userCode;

    /**
     * 直播间创建方式
     * 1： 通过 openAPI 接口创建
     * 其他：通过百家云平台创建
     */
    @JsonProperty("create_from")
    private Integer createFrom;

    /**
     * 进入方式
     * 0 直接进教室，
     * 1 课程私密参加码，
     * 2 公开参加码，
     * 3 白名单进教室，
     * 4 密码观看，
     * 5 云端直播白名单，
     * 6 手机验证
     */
    @JsonProperty("is_private")
    private Integer isPrivate;

    /**
     *  是否分组，0:常规直播 1:分组课堂 2:线上双师
     * */
    @JsonProperty("new_group_live")
    private Integer newGroupLive;

    /**
     * 自动开启云端录制 0:默认 1:开启 2:使用本地配置
     * */
    @JsonProperty("auto_playback_record")
    private Integer autoPlaybackRecord;

    /**
     *  是否是伪直播 0：否 1: 是
     * */
    @JsonProperty("is_mock_live")
    private Integer isMockLive;

    /**
     *  伪直播自动录制 1：是，0：否
     * */
    @JsonProperty("mock_live_record")
    private Integer mockLiveRecord;

    /**
     *  是否是推流直播 0:否 1:是
     * */
    @JsonProperty("is_push_live")
    private Integer isPushLive;

    /**
     *  推流直播自动录制 1：是，0：否
     * */
    @JsonProperty("push_live_record")
    private Integer pushLiveRecord;


    @JsonProperty("template_name")
    private String templateName;

    /**
     *  是否开启直播带货
     * */
    @JsonProperty("enable_live_sell")
    private Integer enableLiveSell;

    /**
     *  是否允许伪直播同步回放聊天消息
     * */
    @JsonProperty("enable_mock_sync_chat_message")
    private Integer enableMockSyncChatMessage;

    @JsonProperty("enable_set_virtual_chat_art")
    private Integer enableSetVirtualChatArt;


    @JsonProperty("enable_mock_sync_chat_art")
    private Integer enableMockSyncChatArt;

    @JsonProperty("app_template")
    private Integer appTemplate;

    @JsonProperty("enable_room_chat_check")
    private Integer enableRoomChatCheck;

    @JsonProperty("mock_data")
    private LiveMockResp mockData;

    @JsonProperty("spot_lives")
    private List<LiveSpotResp> spotLives;

    @JsonProperty("bind_docs")
    private List<LiveBindDocResp> bindDocs;

}
