package com.baijiayun.duanxunbao.sdk.dto.req;

import lombok.Data;

import java.io.Serializable;

@Data
public class CallConfig implements Serializable {

    private Integer supplierType = 0;

    private String callbackHost = "";

    private String callLine = "";

    /**
     * 坐席扣费生效时间，如2022-10-01
     * "validDate":"2022-01-01"
     */
    private String validDate ="";

    /**
     * 网络电话线路num
     */
    private String callAccountNum;

    /**
     * 语音线路num
     */
    private String webCallAccountNum;

    /**
     * 双呼回显线路num
     */
    private String doubleCallAccountNum;

    /**
     * 网络电话账户信息 way_type包含sip,则必填
     */
    private CallAccountConfig accountInfo;

    /**
     * 语音播报场景账户信息
     */
    private CallAccountConfig webCallAccountInfo;

    /**
     * 双呼回显配置 way_type包含local,则必填
     */
    private CallAccountConfig doubleCallAccountInfo;

    /**
     * 语音外呼费用配置
     */
    private WebCallFeeInfo webCallFeeInfo;

    /**
     * 网络电话费用配置
     */
    private CallFeeInfo callFeeInfo;

    /**
     * 双呼回显费用配置 way_type包含local,则必填
     */
    private DoubleCallFeeInfo doubleCallFeeInfo;

    private String wayType = "";
}
