package com.baijiayun.duanxunbao.sdk.dto.req;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.io.Serializable;

@Data
public class CallAccountConfig implements Serializable {

    // 朱雀
    @JsonProperty("call_line")
    @JsonAlias("callLine")
    private String callLine;

    // 容联
    @JsonProperty("account_name")
    @JsonAlias("accountName")
    private String accountName;

    private String password;

    @JsonProperty("account_id")
    @JsonAlias("accountId")
    private String accountId;

    private String pbx;

    @JsonProperty("proxy_url")
    @JsonAlias("proxyUrl")
    private String proxyUrl;

    @JsonProperty("secretkey")
    @JsonAlias("secretKey")
    private String secretKey;

    private String host;

    @JsonProperty("service_no")
    @JsonAlias("serviceNo")
    private String serviceNo;

    @JsonProperty("service_no_voice")
    @JsonAlias("serviceNoVoice")
    private String serviceNoVoice;

    private String url;

    private String account;

    private String pass;

    private String defaultExtenType = StringUtils.EMPTY;

    // 融营
    @JsonProperty("app_id")
    @JsonAlias("appId")
    private String appId;

    @JsonProperty("app_token")
    @JsonAlias("appToken")
    private String appToken;

    @JsonProperty("app_name")
    @JsonAlias("appName")
    private String appName;

    @JsonProperty("account_sid")
    @JsonAlias("accountSid")
    private String accountSid;

    @JsonProperty("account_token")
    @JsonAlias("accountToken")
    private String accountToken;

    @JsonProperty("rest_url")
    @JsonAlias("restUrl")
    private String restUrl;
}
