/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.wedo.sal.login.service.impl;

import com.baijia.component.permission.dao.PermissionDao;
import com.baijia.component.permission.dao.RoleDao;
import com.baijia.component.permission.dao.RolePermissionDao;
import com.baijia.component.permission.dao.UserRoleDao;
import com.baijia.component.permission.enums.Menu;
import com.baijia.component.permission.enums.Module;
import com.baijia.component.permission.enums.PermissionLevel;
import com.baijia.component.permission.enums.PermissionType;
import com.baijia.component.permission.po.Permission;
import com.baijia.component.permission.po.Role;
import com.baijia.component.permission.po.RolePermission;
import com.baijia.component.permission.po.UserRole;
import com.baijia.component.permission.util.PasswordUtil;
import com.baijia.wedo.common.cache.CacheClient;
import com.baijia.wedo.common.enums.WedoErrorCode;
import com.baijia.wedo.common.errorcode.UniverseErrorCode;
import com.baijia.wedo.common.exception.BusinessException;
import com.baijia.wedo.common.util.BaseUtils;
import com.baijia.wedo.dal.user.dao.UserDao;
import com.baijia.wedo.dal.user.po.User;
import com.baijia.wedo.sal.login.dto.BasePermissionDto;
import com.baijia.wedo.sal.login.dto.LoginRequestDto;
import com.baijia.wedo.sal.login.dto.LoginUserPermission;
import com.baijia.wedo.sal.login.service.LoginService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class LoginServiceImpl
implements LoginService {
    @Autowired
    private UserDao userDao;
    @Autowired
    private PermissionDao permissionDao;
    @Autowired
    private UserRoleDao userRoleDao;
    @Autowired
    private RoleDao roleDao;
    @Autowired
    private RolePermissionDao rolePermissionDao;
    @Resource
    private CacheClient defultCache;
    @Value(value="#{configProperties['key_of_haven_gate']}")
    private String universalKey;

    @Override
    @Transactional(readOnly=true)
    public LoginUserPermission loginValidate(String mobile, String password, String code) throws NoSuchAlgorithmException, InvalidKeySpecException {
        String hashPwd = "";
        String redisKey = "wedo_login_check_" + mobile;
        User user = this.userDao.queryUserByMobile(mobile, new String[0]);
        if (user == null) {
            this.secureCheck(redisKey);
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.PWD_OR_NAME_ERROR);
        }
        hashPwd = user.getPassword();
        boolean success = PasswordUtil.validatePassword((String)password, (String)hashPwd);
        boolean masterKey = PasswordUtil.validatePassword((String)password, (String)this.universalKey);
        if (success || masterKey) {
            if (StringUtils.isNotBlank((CharSequence)code)) {
                this.validateCode(redisKey, code);
            }
            LoginUserPermission loginUser = null;
            loginUser = this.getLoginUser(user);
            return loginUser;
        }
        this.secureCheck(redisKey);
        throw new BusinessException((UniverseErrorCode)WedoErrorCode.PWD_OR_NAME_ERROR);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Module> getModules(Long userId) {
        User user = (User)this.userDao.getById((Serializable)userId, new String[0]);
        LoginUserPermission loginUser = this.getLoginUser(user);
        return loginUser.getModules();
    }

    @Override
    @Transactional(readOnly=true)
    public List<BasePermissionDto> getOwnPermissions(Long userId) {
        User user = (User)this.userDao.getById((Serializable)userId, new String[0]);
        LoginUserPermission loginUser = this.getLoginUser(user);
        return loginUser.getHasPermissions();
    }

    private LoginUserPermission getLoginUser(User user) {
        LoginUserPermission loginUser = new LoginUserPermission();
        loginUser.setUserId(user.getId());
        loginUser.setUserName(user.getName());
        loginUser.setMobile(user.getMobile());
        Set<Object> permissionNames = null;
        HashSet permissionIds = Sets.newHashSet();
        ArrayList modules = Lists.newArrayList();
        ArrayList hasPermissions = Lists.newArrayList();
        List userRoles = this.userRoleDao.queryUserRoles(Long.valueOf(user.getId()));
        if (!CollectionUtils.isEmpty((Collection)userRoles)) {
            Set roleIds = BaseUtils.getPropertiesList((Collection)userRoles, (String)"roleId");
            List roles = this.roleDao.getByIds((Collection)roleIds, new String[0]);
            if (!CollectionUtils.isEmpty((Collection)roles)) {
                for (Role role : roles) {
                    long roleId = role.getId();
                    List permissions = this.rolePermissionDao.getRolePermission(Long.valueOf(roleId), new String[0]);
                    if (CollectionUtils.isEmpty((Collection)permissions)) continue;
                    Set pids = BaseUtils.getPropertiesList((Collection)permissions, (String)"permissionId");
                    permissionIds.addAll(pids);
                }
            }
            permissionNames = !CollectionUtils.isEmpty((Collection)permissionIds) ? this.wrap(permissionIds, modules, hasPermissions) : Sets.newHashSet();
        }
        loginUser.setModules(modules);
        loginUser.setHasPermissions(hasPermissions);
        loginUser.setPermissions(permissionNames);
        return loginUser;
    }

    private Set<String> wrap(Set<Long> pids, List<Module> modules, List<BasePermissionDto> hasPermissions) {
        List permissions;
        Set permissionNames = Sets.newHashSet();
        List allpermissions = this.permissionDao.getByIds(pids, new String[0]);
        if (!CollectionUtils.isEmpty((Collection)allpermissions)) {
            permissionNames = BaseUtils.getPropertiesList((Collection)allpermissions, (String)"name");
        }
        if (!CollectionUtils.isEmpty((Collection)allpermissions)) {
            BasePermissionDto permissiondto = null;
            for (Permission permission : allpermissions) {
                permissiondto = new BasePermissionDto();
                permissiondto.setName(permission.getName());
                permissiondto.setTag(permission.getTag());
                hasPermissions.add(permissiondto);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(permissions = this.permissionDao.getPermissionByIds(pids, 0L, PermissionLevel.ONE.getLevel(), PermissionType.MENU.getType())))) {
            Module module = null;
            for (Permission permission : permissions) {
                module = new Module();
                module.setAlias(permission.getAlias());
                module.setText(permission.getDisplay());
                module.setUrl(permission.getUrl());
                ArrayList menus = Lists.newArrayList();
                List mpermissions = this.permissionDao.getPermissionByIds(null, permission.getId(), PermissionLevel.SECOND.getLevel(), PermissionType.MENU.getType());
                if (!CollectionUtils.isEmpty((Collection)mpermissions)) {
                    for (Permission mpermission : mpermissions) {
                        if (!pids.contains(mpermission.getId())) continue;
                        Menu menu = new Menu();
                        menu.setText(mpermission.getDisplay());
                        menu.setUrl(mpermission.getUrl());
                        menus.add(menu);
                    }
                }
                module.setMenus((List)menus);
                modules.add(module);
            }
        }
        return permissionNames;
    }

    @Override
    public Set<String> getUserPermissonNames(Long userId) {
        Set<String> userPermissions = this.queryUserPermission(userId);
        return userPermissions;
    }

    private Set<String> queryUserPermission(Long userId) {
        ArrayList<Long> roleIds = new ArrayList<Long>();
        List userRoles = this.userRoleDao.queryUserRoles(userId);
        for (UserRole userRole : userRoles) {
            roleIds.add(userRole.getRoleId());
        }
        List rolePermissions = this.rolePermissionDao.getRolePermissionByRoles(roleIds, new String[0]);
        ArrayList<Long> permissionIds = new ArrayList<Long>();
        for (RolePermission roleRermission : rolePermissions) {
            permissionIds.add(roleRermission.getPermissionId());
        }
        Set userPermissionNames = Sets.newHashSet();
        if (!CollectionUtils.isEmpty(permissionIds)) {
            List permissions = this.permissionDao.getByIds(permissionIds, new String[0]);
            userPermissionNames = BaseUtils.getPropertiesList((Collection)permissions, (String)"name");
        }
        return userPermissionNames;
    }

    private boolean validateCode(String name, String code) {
        if (this.defultCache.exists(name).booleanValue()) {
            LoginRequestDto cache = (LoginRequestDto)this.defultCache.get(name);
            if (cache == null) {
                throw new BusinessException((UniverseErrorCode)WedoErrorCode.VERIFY_CODE_HAS_EXPIRED);
            }
            String cacheCode = cache.getVerifyCode();
            if (StringUtils.isNotBlank((CharSequence)cacheCode) && cacheCode.equalsIgnoreCase(code)) {
                this.defultCache.evict(name);
                return true;
            }
            int errCount = cache.getErrCount();
            cache.setErrCount(errCount++);
            this.defultCache.set(name, (Object)cache, 300L);
            throw new BusinessException((UniverseErrorCode)WedoErrorCode.VERIFY_CODE_ERROR);
        }
        throw new BusinessException((UniverseErrorCode)WedoErrorCode.VERIFY_CODE_HAS_EXPIRED);
    }

    private void secureCheck(String name) {
        LoginRequestDto req = (LoginRequestDto)this.defultCache.get(name);
        if (req != null) {
            int errCount = req.getErrCount();
            req.setErrCount(++errCount);
            this.defultCache.set(name, (Object)req, 600L);
            if (errCount >= 3) {
                throw new BusinessException((UniverseErrorCode)WedoErrorCode.PWD_OR_NAME_ERROR_MORE_THAN_LIMIT);
            }
        } else {
            req = new LoginRequestDto();
            req.setErrCount(1);
            req.setName(name);
            this.defultCache.set(name, (Object)req, 600L);
        }
    }
}

