/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.invoke;

import com.yonyou.iuap.open.builder.OpenServiceBuilder;
import com.yonyou.iuap.open.http.model.HttpOptions;
import com.yonyou.iuap.open.http.model.HttpResponse;
import com.yonyou.iuap.open.invoke.AbstractInvoke;
import com.yonyou.iuap.open.invoke.InputParam;
import com.yonyou.iuap.open.utils.SignUtil;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EcoInvoke
extends AbstractInvoke {
    private static final Logger log = LoggerFactory.getLogger(EcoInvoke.class);

    @Override
    HttpResponse getResult(OpenServiceBuilder openServiceBuilder, InputParam inputParam, String tenantId, String suiteTicket) {
        HttpResponse httpResponse;
        Object[] mid = EcoInvoke.paramTransfer(openServiceBuilder, inputParam);
        String appKey = (String)mid[0];
        String appSecret = (String)mid[1];
        String url = (String)mid[2];
        String authDomain = (String)mid[3];
        String method = (String)mid[4];
        String contentType = (String)mid[5];
        Map query = (Map)mid[6];
        Map header = (Map)mid[7];
        String bodyStr = (String)mid[8];
        HttpOptions httpOptions = EcoInvoke.assembleHttpOptions(openServiceBuilder);
        String tokenCache = (String)tokenMap.get((Object)EcoInvoke.getTokenCacheKey(appKey, appSecret, tenantId));
        try {
            String accessToken = StringUtils.isNotBlank((CharSequence)tokenCache) ? tokenCache : this.getToken(appKey, appSecret, tenantId, suiteTicket, authDomain, httpOptions);
            httpResponse = EcoInvoke.call(url, accessToken, method, query, header, bodyStr, httpOptions, contentType);
            String resultStr = httpResponse.getResult();
            if (null != resultStr && StringUtils.equalsIgnoreCase((CharSequence)resultStr, (CharSequence)"{\"code\":\"310036\",\"message\":\"\u975e\u6cd5token\"}")) {
                accessToken = this.getToken(appKey, appSecret, tenantId, suiteTicket, authDomain, httpOptions);
                httpResponse = EcoInvoke.call(url, accessToken, method, query, header, bodyStr, httpOptions, contentType);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return httpResponse;
    }

    @Override
    String getToken(String suiteKey, String suiteSecret, String tenantId, String suiteTicket, String authUrl, HttpOptions httpOptions) {
        try {
            TreeMap<String, String> params = new TreeMap<String, String>();
            params.put("suiteKey", suiteKey);
            params.put("tenantId", tenantId);
            if (StringUtils.isNotBlank((CharSequence)suiteTicket)) {
                params.put("suiteTicket", suiteTicket);
            }
            params.put("timestamp", String.valueOf(System.currentTimeMillis()));
            String signature = SignUtil.sign(params, suiteSecret);
            params.put("signature", signature);
            String requestUrl = authUrl + "/open-auth/suiteApp/getAccessToken";
            return this.getTokenResult(suiteKey, suiteSecret, tenantId, httpOptions, params, requestUrl);
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u751f\u6001\u5e94\u7528\u83b7\u53d6token\u7684\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), (Throwable)e);
            throw new RuntimeException("\u8c03\u7528\u751f\u6001\u5e94\u7528\u83b7\u53d6token\u7684\u63a5\u53e3\u51fa\u73b0\u5f02\u5e38:" + e.getMessage(), e);
        }
    }
}

