/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.invoke;

import com.yonyou.iuap.open.builder.OpenServiceBuilder;
import com.yonyou.iuap.open.http.HttpClientUtil;
import com.yonyou.iuap.open.http.model.HttpOptions;
import com.yonyou.iuap.open.http.model.HttpRequest;
import com.yonyou.iuap.open.http.model.HttpResponse;
import com.yonyou.iuap.open.invoke.InputParam;
import com.yonyou.iuap.open.module.Result;
import com.yonyou.iuap.open.utils.AssertUtil;
import com.yonyou.iuap.open.utils.BeanJsonConvertUtil;
import com.yonyou.iuap.open.utils.UrlUtil;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import net.jodah.expiringmap.ExpiringMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInvoke {
    private static final Logger log = LoggerFactory.getLogger(AbstractInvoke.class);
    public static Map<String, String> map = new HashMap<String, String>();
    protected static Map<String, String> tokenUrlMap = new HashMap<String, String>();
    protected static ExpiringMap<String, String> tokenMap = ExpiringMap.builder().variableExpiration().build();

    protected static String getTokenCacheKey(String appKey, String appSecret, String tenantId) {
        String result = StringUtils.isBlank((CharSequence)tenantId) ? appKey + "###" + appSecret : appKey + "###" + appSecret + "###" + tenantId;
        return result;
    }

    protected static HttpResponse call(String url, String accessToken, String method, Map<String, String> query, Map<String, String> header, String bodyStr, HttpOptions httpOptions, String contentType) {
        url = UrlUtil.addUrlParams(url, "access_token", accessToken);
        HttpResponse httpResponse = null;
        HttpRequest httpRequest = new HttpRequest();
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)"GET", (CharSequence)method)) {
                httpRequest.setParams(query).setHeaders(header).setUrl(url);
                httpResponse = HttpClientUtil.httpGet(httpRequest, httpOptions);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)"POST", (CharSequence)method)) {
                if (StringUtils.contains((CharSequence)contentType, (CharSequence)ContentType.APPLICATION_JSON.getMimeType())) {
                    httpResponse = HttpClientUtil.httpPostJson(url, bodyStr, header, query, httpOptions);
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)contentType, (CharSequence)ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
                    Map<String, String> bodyMap = BeanJsonConvertUtil.jsonToMap(bodyStr, String.class, String.class);
                    httpRequest.setUrl(url).setParams(bodyMap).setHeaders(header).setQueries(query);
                    httpResponse = HttpClientUtil.httpPost(httpRequest, httpOptions);
                }
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528OpenAPI\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u8c03\u7528OpenAPI\u51fa\u73b0\u5f02\u5e38" + e.getMessage(), e);
        }
        return httpResponse;
    }

    protected static HttpOptions assembleHttpOptions(OpenServiceBuilder openServiceBuilder) {
        HttpOptions httpOptions = openServiceBuilder.getHttpOptions();
        if (null == httpOptions) {
            httpOptions = new HttpOptions();
            String retryCount = map.get("retryCount");
            String connectionRequestTimeout = map.get("connectionRequestTimeout");
            String socketTimeout = map.get("socketTimeout");
            String connectionTimeout = map.get("connectionTimeout");
            httpOptions.setRetryCount(StringUtils.isBlank((CharSequence)retryCount) ? null : Integer.valueOf(retryCount));
            httpOptions.setConnectionRequestTimeout(StringUtils.isBlank((CharSequence)connectionRequestTimeout) ? null : Integer.valueOf(connectionRequestTimeout));
            httpOptions.setSocketTimeout(StringUtils.isBlank((CharSequence)socketTimeout) ? null : Integer.valueOf(socketTimeout));
            httpOptions.setConnectionTimeout(StringUtils.isBlank((CharSequence)connectionTimeout) ? null : Integer.valueOf(connectionTimeout));
        }
        return httpOptions;
    }

    protected static Object[] paramTransfer(OpenServiceBuilder openServiceBuilder, InputParam inputParam) {
        Object[] result = new Object[9];
        String env = openServiceBuilder.getEnv();
        String authDomain = openServiceBuilder.getAuthDomain();
        String apiDomain = openServiceBuilder.getApiDomain();
        String appKey = openServiceBuilder.getAppKey();
        AssertUtil.stringNotBlank("appKey", appKey);
        String appSecret = openServiceBuilder.getAppSecret();
        AssertUtil.stringNotBlank("appSecret", appSecret);
        String url = inputParam.getUrl();
        AssertUtil.stringNotBlank("url", url);
        String method = inputParam.getMethod();
        AssertUtil.stringNotBlank("method", method);
        String contentType = inputParam.getContentType();
        AssertUtil.stringNotBlank("contentType", contentType);
        Map<String, String> query = inputParam.getQuery();
        Map<String, String> header = inputParam.getHeader();
        String bodyStr = BeanJsonConvertUtil.beanToJson(inputParam.getBody());
        boolean ytsTransaction = openServiceBuilder.isYtsTransaction();
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{authDomain, apiDomain})) {
            if (StringUtils.startsWith((CharSequence)env, (CharSequence)"http")) {
                authDomain = env + "/iuap-api-auth";
                apiDomain = env + "/iuap-api-gateway";
            } else {
                env = StringUtils.isBlank((CharSequence)env) ? "prod" : env;
                String domain = tokenUrlMap.get(env);
                authDomain = domain + "/iuap-api-auth";
                apiDomain = domain + "/iuap-api-gateway";
            }
        }
        if (!url.startsWith("http")) {
            url = apiDomain + url;
        }
        if (null == query) {
            query = new HashMap<String, String>();
        }
        if (null == header) {
            header = new HashMap<String, String>();
        }
        if (ytsTransaction) {
            header.put("ytsEnable", String.valueOf(true));
        }
        result[0] = appKey;
        result[1] = appSecret;
        result[2] = url;
        result[3] = authDomain;
        result[4] = method;
        result[5] = contentType;
        result[6] = query;
        result[7] = header;
        result[8] = bodyStr;
        return result;
    }

    abstract HttpResponse getResult(OpenServiceBuilder var1, InputParam var2, String var3, String var4);

    abstract String getToken(String var1, String var2, String var3, String var4, String var5, HttpOptions var6);

    protected String getTokenResult(String appKey, String appSecret, String tenantId, HttpOptions httpOptions, TreeMap<String, String> params, String requestUrl) throws Exception {
        HttpRequest httpRequest = new HttpRequest();
        httpRequest.setUrl(requestUrl).setParams(params);
        HttpResponse httpResponse = HttpClientUtil.httpGet(httpRequest, httpOptions);
        if (200 == httpResponse.getStatusCode()) {
            String result = httpResponse.getResult();
            Result resultDomain = BeanJsonConvertUtil.jsonToBean(result, Result.class);
            if (resultDomain.isSuccess()) {
                Object data = resultDomain.getData();
                Map<String, String> resultMap = BeanJsonConvertUtil.jsonToMap(BeanJsonConvertUtil.beanToJson(data), String.class, String.class);
                String accessToken = resultMap.get("access_token");
                if (StringUtils.isNotEmpty((CharSequence)accessToken)) {
                    accessToken = URLEncoder.encode(accessToken, "UTF-8");
                }
                Long expire = Long.valueOf(resultMap.get("expire"));
                String tokenCacheKey = AbstractInvoke.getTokenCacheKey(appKey, appSecret, tenantId);
                tokenMap.put((Object)tokenCacheKey, (Object)accessToken);
                tokenMap.setExpiration((Object)tokenCacheKey, expire.longValue(), TimeUnit.SECONDS);
                return accessToken;
            }
            throw new RuntimeException(result);
        }
        String errorMsg = "HTTP\u72b6\u6001\u7801:" + httpResponse.getStatusCode() + "\u8fd4\u56de\u4fe1\u606f:" + httpResponse.getResult();
        String allErrorMsg = "key:" + appKey + ",secret:" + appSecret + "\u8c03\u7528\u7ed3\u679c:" + errorMsg;
        log.error(allErrorMsg);
        throw new RuntimeException(allErrorMsg);
    }

    static {
        tokenUrlMap.put("daily", "https://bip-daily.yyuap.com");
        tokenUrlMap.put("pre", "https://bip-pre.diwork.com");
        tokenUrlMap.put("prod", "https://yonbip.diwork.com");
        tokenUrlMap.put("dbox", "https://dbox.diwork.com");
        tokenUrlMap.put("test", "https://bip-test.yyuap.com");
        tokenUrlMap.put("stage", "https://yonbip-core1.diwork.com");
        ResourceBundle bundle = ResourceBundle.getBundle("open", Locale.getDefault());
        for (String s : bundle.keySet()) {
            map.put(s, bundle.getString(s));
        }
    }
}

