/*
 * Decompiled with CFR 0.152.
 */
package com.yonyou.iuap.open.http;

import com.yonyou.iuap.open.http.handler.HttpRequestRetryHandler;
import com.yonyou.iuap.open.http.model.HttpOptions;
import com.yonyou.iuap.open.http.model.HttpRequest;
import com.yonyou.iuap.open.http.model.HttpResponse;
import com.yonyou.iuap.open.invoke.AbstractInvoke;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpClientUtil.class);
    private static PoolingHttpClientConnectionManager CONNECTION_MANAGER = HttpClientUtil.buildPoolingHttpClientConnectionManager(null, null);

    public static void init(int maxTotal, int maxPerRoute) {
        CONNECTION_MANAGER = HttpClientUtil.buildPoolingHttpClientConnectionManager(maxTotal, maxPerRoute);
    }

    public static HttpResponse httpGet(HttpRequest httpRequest) throws Exception {
        return HttpClientUtil.httpGet(httpRequest, null);
    }

    public static HttpResponse httpGet(HttpRequest httpRequest, HttpOptions httpOptions) throws Exception {
        HttpGet httpGet = new HttpGet(HttpClientUtil.assembleUrl(httpRequest.getUrl(), httpRequest.getParams()));
        if (Objects.nonNull(httpRequest.getHeaders())) {
            for (Map.Entry<String, String> header : httpRequest.getHeaders().entrySet()) {
                httpGet.addHeader(header.getKey(), String.valueOf(header.getValue()));
            }
        }
        return HttpClientUtil.doHttp((HttpRequestBase)httpGet, httpOptions);
    }

    public static HttpResponse httpPost(HttpRequest httpRequest) throws Exception {
        return HttpClientUtil.httpPost(httpRequest, null);
    }

    public static HttpResponse httpPost(HttpRequest httpRequest, HttpOptions httpOptions) throws Exception {
        HttpPost httpPost = new HttpPost(HttpClientUtil.assembleUrl(httpRequest.getUrl(), httpRequest.getQueries()));
        List<NameValuePair> pairs = HttpClientUtil.convertParams2NVPS(httpRequest.getParams());
        if (!pairs.isEmpty()) {
            httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(pairs, StandardCharsets.UTF_8.name()));
        }
        if (Objects.nonNull(httpRequest.getHeaders())) {
            for (Map.Entry<String, String> header : httpRequest.getHeaders().entrySet()) {
                httpPost.addHeader(header.getKey(), String.valueOf(header.getValue()));
            }
        }
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost, httpOptions);
    }

    public static HttpResponse httpPostJson(String url, String param, Map<String, String> header, HttpOptions httpOptions) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/json; charset=UTF-8");
        if (Objects.nonNull(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPost.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(param, StandardCharsets.UTF_8.name()));
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost, httpOptions);
    }

    public static HttpResponse httpPostJson(String url, String param, Map<String, String> header, Map<String, String> query, HttpOptions httpOptions) throws Exception {
        URI uri = HttpClientUtil.assembleUrl(url, query);
        return HttpClientUtil.httpPostJson(uri.toURL().toString(), param, header, httpOptions);
    }

    public static HttpResponse httpPostXml(String url, String param, Map<String, String> header, HttpOptions httpOptions) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        httpPost.addHeader("Content-Type", "application/xml; charset=UTF-8");
        if (Objects.nonNull(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPost.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)new StringEntity(param, StandardCharsets.UTF_8.name()));
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost, httpOptions);
    }

    public static HttpResponse httpPostMultipart(String url, Map<String, ContentBody> multiparts, Map<String, String> header, HttpOptions httpOptions) throws Exception {
        HttpPost httpPost = new HttpPost(url);
        if (Objects.nonNull(multiparts)) {
            MultipartEntityBuilder multipartEntityBuilder = MultipartEntityBuilder.create();
            for (Map.Entry<String, ContentBody> multipartEntry : multiparts.entrySet()) {
                multipartEntityBuilder.addPart(multipartEntry.getKey(), multipartEntry.getValue());
            }
            httpPost.setEntity(multipartEntityBuilder.build());
        }
        if (Objects.nonNull(header)) {
            for (Map.Entry<String, String> entry : header.entrySet()) {
                httpPost.addHeader(entry.getKey(), String.valueOf(entry.getValue()));
            }
        }
        return HttpClientUtil.doHttp((HttpRequestBase)httpPost, httpOptions);
    }

    public static String convertParams2QueryStr(Map<String, ?> params) {
        List<NameValuePair> pairs = HttpClientUtil.convertParams2NVPS(params);
        return URLEncodedUtils.format(pairs, (String)StandardCharsets.UTF_8.name());
    }

    public static List<NameValuePair> convertParams2NVPS(Map<String, ?> params) {
        if (Objects.isNull(params)) {
            return new ArrayList<NameValuePair>();
        }
        return params.entrySet().stream().map(param -> new BasicNameValuePair((String)param.getKey(), String.valueOf(param.getValue()))).collect(Collectors.toList());
    }

    private static HttpResponse doHttp(HttpRequestBase request, HttpOptions httpOptions) throws Exception {
        if (Objects.isNull(httpOptions)) {
            httpOptions = HttpOptions.DEFAULT_HTTP_OPTION;
        }
        RequestConfig.Builder builder = RequestConfig.custom();
        if (Objects.nonNull(httpOptions.getSocketTimeout())) {
            builder = builder.setSocketTimeout(httpOptions.getSocketTimeout().intValue());
        }
        if (Objects.nonNull(httpOptions.getConnectionTimeout())) {
            builder = builder.setConnectTimeout(httpOptions.getConnectionTimeout().intValue());
        }
        if (Objects.nonNull(httpOptions.getConnectionRequestTimeout())) {
            builder = builder.setConnectionRequestTimeout(httpOptions.getConnectionRequestTimeout().intValue());
        }
        RequestConfig requestConfig = builder.build();
        request.setConfig(requestConfig);
        HttpRequestRetryHandler httpRequestRetryHandler = null;
        if (Objects.nonNull(httpOptions.getRetryCount())) {
            httpRequestRetryHandler = new HttpRequestRetryHandler(httpOptions.getRetryCount());
        }
        if (Objects.nonNull(httpOptions.getHttpMaxTotal())) {
            CONNECTION_MANAGER.setMaxTotal(httpOptions.getHttpMaxTotal().intValue());
        }
        if (Objects.nonNull(httpOptions.getHttpMaxPerRoute())) {
            CONNECTION_MANAGER.setDefaultMaxPerRoute(httpOptions.getHttpMaxPerRoute().intValue());
        }
        HttpClientBuilder httpClientBuilder = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)CONNECTION_MANAGER).setRetryHandler((org.apache.http.client.HttpRequestRetryHandler)httpRequestRetryHandler);
        try {
            ServiceLoader<HttpRequestInterceptor> requestInterceptors = ServiceLoader.load(HttpRequestInterceptor.class);
            requestInterceptors.forEach(x -> httpClientBuilder.addInterceptorFirst(x));
            ServiceLoader<HttpResponseInterceptor> responseInterceptors = ServiceLoader.load(HttpResponseInterceptor.class);
            responseInterceptors.forEach(x -> httpClientBuilder.addInterceptorFirst(x));
        }
        catch (Throwable e) {
            log.error(e.getMessage(), e);
        }
        CloseableHttpClient httpClient = httpClientBuilder.build();
        return HttpClientUtil.doRequest(httpClient, request);
    }

    private static HttpResponse doRequest(CloseableHttpClient httpClient, HttpRequestBase request) throws Exception {
        HttpResponse res = new HttpResponse();
        CloseableHttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = httpClient.execute((HttpUriRequest)request);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)StandardCharsets.UTF_8.name());
            EntityUtils.consume((HttpEntity)entity);
            HashMap<String, String> headers = new HashMap<String, String>(response.getAllHeaders().length);
            for (Header header : response.getAllHeaders()) {
                headers.put(header.getName(), header.getValue());
            }
            res.setStatusCode(response.getStatusLine().getStatusCode()).setResult(result).setHeaders(headers);
        }
        catch (Exception e) {
            log.error("HTTP\u8bf7\u6c42\u8c03\u7528\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (Objects.nonNull(response)) {
                response.close();
            }
        }
        long elapsed = System.currentTimeMillis() - start;
        log.debug("op=end_doRequest,request={},res={},elapsed={}", new Object[]{request, res, elapsed});
        return res;
    }

    private static PoolingHttpClientConnectionManager buildPoolingHttpClientConnectionManager(Integer maxTotal, Integer maxPerRoute) {
        PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(HttpClientUtil.getRegistry());
        String maxTotalProperty = null;
        if (Objects.nonNull(maxTotal)) {
            connectionManager.setMaxTotal(maxTotal.intValue());
        } else {
            maxTotalProperty = System.getenv("httpMaxTotal");
            if (Objects.isNull(maxTotalProperty)) {
                maxTotalProperty = AbstractInvoke.map.get("httpMaxTotal");
            }
            if (Objects.nonNull(maxTotalProperty)) {
                connectionManager.setMaxTotal(Integer.valueOf(maxTotalProperty).intValue());
            }
        }
        String maxPerRouteProperty = null;
        if (Objects.nonNull(maxPerRoute)) {
            connectionManager.setDefaultMaxPerRoute(maxPerRoute.intValue());
        } else {
            maxPerRouteProperty = System.getenv("httpMaxPerRoute");
            if (Objects.isNull(maxPerRouteProperty)) {
                maxPerRouteProperty = AbstractInvoke.map.get("httpMaxPerRoute");
            }
            if (Objects.nonNull(maxPerRouteProperty)) {
                connectionManager.setDefaultMaxPerRoute(Integer.valueOf(maxPerRouteProperty).intValue());
            }
        }
        log.info("[COMMON_SUCCESS_buildPoolingHttpClientConnectionManager]maxTotal={},maxPerRoute={},maxTotalProperty={},maxPerRouteProperty={}", new Object[]{maxTotal, maxPerRoute, maxTotalProperty, maxPerRouteProperty});
        return connectionManager;
    }

    private static Registry<ConnectionSocketFactory> getRegistry() {
        try {
            return RegistryBuilder.create().register("http", (Object)new PlainConnectionSocketFactory()).register("https", (Object)new SSLConnectionSocketFactory(SSLContext.getDefault())).build();
        }
        catch (Exception e) {
            log.error("[ERROR_getRegistry]", (Throwable)e);
            return null;
        }
    }

    private static URI assembleUrl(String url, Map<String, String> query) throws URISyntaxException {
        URIBuilder ub = new URIBuilder(url);
        List<NameValuePair> queryPairs = HttpClientUtil.convertParams2NVPS(query);
        if (!queryPairs.isEmpty()) {
            ub.addParameters(queryPairs);
        }
        return ub.build();
    }
}

