package cn.kinyun.scrm.weixin.sdk.utils;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

import java.io.IOException;

/**
 * desc:
 *
 * @author yanmaoyuan
 */
public final class JsonUtil {
    // can reuse, share globally
    private static final ObjectMapper MAPPER;

    private JsonUtil() {}

    static {
        MAPPER = new ObjectMapper();
        MAPPER.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    public static String obj2Str(Object o) {
        try {
            return MAPPER.writeValueAsString(o);
        } catch (IOException ignore) {
            return null;
        }
    }
}
