/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.enums;

/**
 * 微信素材类型
 * 
 * @title WxMediaType
 * @desc 素材类型
 * @author yanmaoyuan
 * @date 2019年4月24日
 * @version 1.0
 */
@SuppressWarnings("squid:S115")
public enum WxMediaType {
    /**
     * 图文
     */
    News("news"),
    /**
     * 图片
     */
    Image("image"),

    /**
     * 语音
     */
    Voice("voice"),

    /**
     * 视频
     */
    Video("video"),

    /**
     * 缩略图
     */
    Thumb("thumb"),

    //以上为官方素材类型

    //以下为平台新增素材类型
    /**
     * 临时图片素材
     */
    Tmp_image("tmp_image")

    ;

    private String value;

    private WxMediaType(String value) {
        this.value = value;
    }

    public String getValue() {
        return value;
    }
}