/**
 * kuaike.com Inc.
 * Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.template;

import cn.kinyun.scrm.weixin.sdk.entity.miniprogram.MiniProgram;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;

import java.io.Serializable;
import java.util.Map;

import lombok.Data;

/**
 * 模板消息
 * 
 * @title TemplateMsg
 * @desc 模板消息
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
public class TemplateMsg implements Serializable {

    private static final long serialVersionUID = 5549359167276274763L;

    /**
     * 接收者openid
     */
    @JsonProperty("touser")
    @JsonAlias({"openId", "toUserName"})
    private String toUserName;

    /**
     * 模板ID
     */
    @JsonProperty("template_id")
    @JsonAlias("templateId")
    private String templateId;

    /**
     * 模板跳转链接（海外帐号没有跳转能力）
     * 
     * <p>url和miniprogram都是非必填字段，若都不传则模板无跳转；若都传，会优先跳转至小程序。开发者可根据实际需要选择其中一种跳转方式即可。当用户的微信客户端版本不支持跳小程序时，将会跳转至url。</p>
     */
    private String url;// 可选

    /**
     * 小程序
     * 
     * <p>url和miniprogram都是非必填字段，若都不传则模板无跳转；若都传，会优先跳转至小程序。开发者可根据实际需要选择其中一种跳转方式即可。当用户的微信客户端版本不支持跳小程序时，将会跳转至url。</p>
     */
    @JsonProperty("miniprogram")
    private MiniProgram miniProgram;// 可选

    /**
     * 模板数据
     */
    private Map<String, TemplateParam> data;
}