package cn.kinyun.scrm.weixin.sdk.entity.shop.req;

import cn.kinyun.scrm.weixin.sdk.entity.shop.dto.*;
import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.List;

/**
 * @Desc
 * @Author zhangjing
 * @Date 2021/12/31 4:57 下午
 * @Version 1.0
 */
@Data
public class SpuAddReq {

    /**
     * 商家自定义商品ID，与product_id二选一，需要自行保证单appid内唯一，一旦添加成功后该字段无法修改，最多32字符
     */
    @JsonProperty("out_product_id")
    protected String outProductId;

    /**
     * 标题，最多60字符
     */
    protected String title;

    /**
     * 副标题，最多18字符
     */
    @JsonProperty("sub_title")
    protected String subTitle;

    /**
     * 主图，多张，列表，最多9张
     */
    @JsonProperty("head_img")
    protected List<String> headImg;

    /**
     * 商品详情，图文(目前只支持图片，最多20张)
     */
    @JsonProperty("desc_info")
    protected SpuDescInfo descInfo;

    /**
     * 品牌ID，商家需要申请品牌并通过获取品牌接口brand/get获取，如果是无品牌请填2100000000
     */
    @JsonProperty("brand_id")
    protected String brandId;

    /**
     * 类目
     */
    @JsonProperty("cats")
    protected List<CategoryLevelDto> cats;

    /**
     * 属性
     */
    protected List<AttrItem> attrs;

    /**
     * 商品型号
     */
    protected String model;

    /**
     * 运费
     */
    @JsonProperty("express_info")
    protected ExpressInfo expressInfo;

    /**
     * skus 列表
     */
    protected List<SkuItem> skus;

    /**
     * 1-实物商品 2-券码商品。不填默认为实物商品。必须添加商品传入的类型保持一致，否则会返回参数错误。
     */
    @JsonProperty("product_type")
    protected Integer productType;

    /**
     * 核销设置
     */
    @JsonProperty("couponcode_info")
    private CouponCodeInfo couponcodeInfo;

}
