package cn.kinyun.scrm.weixin.sdk.entity.shop.dto.coupon;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/5 5:40 下午
 */
@Data
public class CouponDto {

    /**
     * 优惠券id
     */
    @JsonAlias("coupon_id")
    private Long couponId;

    /**
     * 优惠券类型
     *
     * 枚举值	描述
     * 1	商品条件折扣券
     * 2	商品满减券
     * 3	商品统一折扣券
     * 4	商品直减券
     * 101	店铺条件折扣券
     * 102	店铺满减券
     * 103	店铺统一折扣券
     * 104	店铺直减券ß
     */
    private Integer type;

    /**
     * 优惠券状态
     *
     * 枚举值	描述
     * 1	未生效，编辑中
     * 2	生效
     * 3	已过期
     * 4	已作废
     * 5	删除
     * 200	过期 or 作废的券
     */
    private Integer status;

    /**
     * 优惠券创建时间
     */
    @JsonAlias("create_time")
    private String createTime;

    /**
     * 优惠券更新时间
     */
    @JsonAlias("update_time")
    private String updateTime;

    @JsonAlias("coupon_info")
    private CouponInfo couponInfo;

    @JsonAlias("stock_info")
    private StockInfo stockInfo;
}
