package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Data;

import java.util.List;

/**
 * @author zhangjing
 * @date 2022/1/4 5:01 下午
 */
@Data
public class ProductInfo {

    /**
     * 已发货商品小商店内部商品ID
     */
    @JsonProperty("product_id")
    private Long productId;

    /**
     * 已发货商品小商店内部skuID
     */
    @JsonProperty("sku_id")
    private Long skuId;

    /**
     * sku小图
     */
    @JsonProperty("thumb_img")
    private String thumbImg;

    /**
     * sku数量
     */
    @JsonProperty("sku_cnt")
    private Long skuCnt;

    /**
     * 已发货商品数量
     */
    @JsonProperty("product_cnt")
    private Long productCnt;

    /**
     * 正在售后/退款流程中的sku数量
     */
    @JsonProperty("on_aftersale_sku_cnt")
    private Integer onAfterSaleSkuCnt;

    @JsonProperty("title")
    private String title;

    /**
     * 完成售后/退款的sku数量
     */
    @JsonProperty("finish_aftersale_sku_cnt")
    private Integer finishAfterSaleSkuCnt;

    /**
     * 售卖价格（单位：分）
     */
    @JsonProperty("sale_price")
    private Long salePrice;

    @JsonProperty("sku_attrs")
    private List<AttrItem> skuAttrs;
}
