package cn.kinyun.scrm.weixin.sdk.entity.shop.dto;

import com.fasterxml.jackson.annotation.JsonAlias;
import lombok.Data;

/**
 * @author zhangjing
 * @date 2022/1/4 4:50 下午
 */
@Data
public class PriceInfoDto {

    /**
     * 商品金额（单位：分）
     */
    @JsonAlias("product_price")
    private Long productPrice;

    /**
     * 订单金额（单位：分）
     */
    @JsonAlias("order_price")
    private Long orderPrice;

    /**
     * 运费（单位：分）
     */
    private Long freight;

    /**
     * 优惠金额（单位：分）
     */
    @JsonAlias("discounted_price")
    private Long discountedPrice;

    /**
     * 是否有优惠（false：无优惠/true：有优惠）
     */
    @JsonAlias("is_discounted")
    private Boolean isDiscounted;

    /**
     * 改价
     * 如果有改价 会返回这个字段
     */
    @JsonAlias("change_down_price")
    private Long changeDownPrice;
}
