/**
 * kuaike.com Inc. Copyright (c) 2014-2019 All Rights Reserved.
 */
package cn.kinyun.scrm.weixin.sdk.entity.message.mass.resp;

import com.fasterxml.jackson.annotation.JsonAlias;
import com.fasterxml.jackson.annotation.JsonProperty;
import cn.kinyun.scrm.weixin.sdk.entity.ErrorCode;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 群发消息的返回结果
 * 
 * @title MsgId
 * @desc 群发消息的返回结果
 * @author yanmaoyuan
 * @date 2019年4月28日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsgId extends ErrorCode {

    private static final long serialVersionUID = -6495962643527437768L;

    /**
     * 消息发送任务的ID
     */
    @JsonProperty("msg_id")
    @JsonAlias({"msgid", "msgId"})
    private String msgId;

    /**
     * 消息的数据ID，该字段只有在群发图文消息时才会出现。可以用于在图文分析数据接口中，获取到对应的图文消息的数据，是图文分析数据接口中的msgid字段中的前半部分，详见图文分析数据接口中的msgid字段的介绍。
     */
    @JsonProperty("msg_data_id")
    private String msgDataId;
}