package cn.kinyun.scrm.weixin.sdk.entity.menu.dto;

import com.fasterxml.jackson.annotation.JsonProperty;

import java.util.List;

import lombok.Data;

/**
 * @ClassName NewsInfo
 * @Description
 * @Author zhangjing
 * @DATE 2019/4/28 10:48
 * @Version 1.0
 */
@Data
public class NewsInfo {
    @JsonProperty("list")
    List<NewInfoItem> list;

    @Data
    public static class NewInfoItem {

        /**
         * 图文消息的标题
         */
        @JsonProperty("title")
        String title;

        /**
         * 作者
         */
        @JsonProperty("author")
        String author;

        /**
         * 摘要
         */
        @JsonProperty("digest")
        String digest;

        /**
         * 是否显示封面，0为不显示，1为显示
         */
        @JsonProperty("show_cover")
        Integer showCover;

        /**
         * 封面图片的URL
         */
        @JsonProperty("cover_url")
        String coverUrl;

        /**
         * 正文的URL
         */
        @JsonProperty("content_url")
        String contentUrl;

        /**
         * 原文的URL，若置空则无查看原文入口
         */
        @JsonProperty("source_url")
        String sourceUrl;
    }
}

