package cn.kinyun.scrm.weixin.sdk.entity.component;

import com.fasterxml.jackson.annotation.JsonAlias;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * @author : shanyu
 * @version V1.0
 * @Project: weixin-platform
 * @Package com.kuaike.weixin.entity.component
 * @date Date : 2019年06月02日 11:23
 */
@Data
public class AuthorizationInfo implements Serializable {

    private static final long serialVersionUID = -1050054532388286444L;

    /**
     * 授权方appId,通过授权码接口调用
     */
    @JsonAlias("authorizer_appid")
    private String authorizerAppId;

    /**
     * 授权方appId，通过授权方appId调用
     */
    @JsonAlias("authorization_appid")
    private String authorizationAppId;

    /**
     * 授权方接口调用凭据
     */
    @JsonAlias("authorizer_access_token")
    private String authorizerAccessToken;

    /**
     * 有效期（在授权的公众号或小程序具备API权限时，才有此返回值）
     */
    @JsonAlias("expires_in")
    private long expires;

    /**
     * 接口调用凭据刷新令牌（在授权的公众号具备API权限时，才有此返回值），</br>
     * 刷新令牌主要用于第三方平台获取和刷新已授权用户的access_token，</br>
     * 只会在授权时刻提供，请妥善保存。 一旦丢失，只能让用户重新授权，才能再次拿到新的刷新令牌</br>
     */
    @JsonAlias("authorizer_refresh_token")
    private String authorizerRefreshToken;

    /**
     * 授权给开发者的权限集列表
     */
    @JsonAlias("func_info")
    private List<FunctionInfo> funcInfo;
}
