package com.kuaike.scrm.common.service.dto.req;

import com.google.common.base.Preconditions;
import com.kuaike.common.sqlbuilder.dto.PageDto;
import lombok.Data;

import java.io.Serializable;

/**
 * @Date: 2022/10/19 15:00
 * @Author: dayu
 */
@Data
public class ScrmSkuProductReq implements Serializable {

    private Long bizId;

    private Integer platform;

    private String shopId;

    private String title;

    private Integer status;

    private PageDto pageDto;

    public void validate() {
        Preconditions.checkArgument(bizId != null, "商户ID不能为空");
        Preconditions.checkArgument(platform != null, "平台不能为空");
        Preconditions.checkArgument(pageDto != null, "分页信息不能为空");
    }
}
