/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.dubbo.filter;

import com.alibaba.dubbo.common.extension.Activate;
import com.alibaba.dubbo.rpc.Filter;
import com.alibaba.dubbo.rpc.Invocation;
import com.alibaba.dubbo.rpc.Invoker;
import com.alibaba.dubbo.rpc.Result;
import com.alibaba.dubbo.rpc.RpcException;
import com.alibaba.dubbo.rpc.RpcInvocation;
import com.kuaike.scrm.common.utils.LoginUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Activate(group={"consumer"})
public class ConsumerTraceFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(ConsumerTraceFilter.class);

    public Result invoke(Invoker<?> invoker, Invocation invocation) throws RpcException {
        try {
            RpcInvocation rpcInvocation = (RpcInvocation)invocation;
            this.setSessionAttachment(rpcInvocation);
            return invoker.invoke(invocation);
        }
        catch (RpcException e) {
            log.error("rpc invoke failed", (Throwable)e);
            return null;
        }
    }

    private void setSessionAttachment(RpcInvocation invocation) {
        if (LoginUtils.getCurrentUser() != null) {
            Long userId = LoginUtils.getCurrentUserId();
            String sessionId = LoginUtils.getSessionId();
            log.debug("attach rpc sessionId:{}, userId:{}", (Object)sessionId, (Object)userId);
            invocation.setAttachment("sessionId", sessionId);
            invocation.setAttachment("userId", String.valueOf(userId));
        }
    }
}

