package com.kuaike.trace.interceptor;

import com.kuaike.trace.utils.TraceIdUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author louis
 * @date 2022/5/25
 * web 支持 traceId 拦截器
 */
@Slf4j
public class TraceIdHandlerInterceptor extends HandlerInterceptorAdapter {

    @Value("${web.traceId.prefix:}")
    private String traceIdPrefix;


    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {

            TraceIdUtils.generateTraceIdToRequest(request, TraceIdUtils.getTraceTypeByValue(traceIdPrefix));
        } catch (Exception e) {
            log.error("增加traceId 异常：errorMsg:", e);
        }
        return true;
    }
    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
        TraceIdUtils.removeTraceId();
    }

}
