/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums.sop;

import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum SopTaskType {
    GROUP_SEND(1, "\u4f01\u5fae\u7fa4\u53d1"),
    CALL(2, "\u4eba\u5de5\u5916\u547c"),
    SMS(3, "\u77ed\u4fe1"),
    TEL_ADD_FRIEND(4, "\u6279\u91cf\u52a0\u597d\u53cb");

    private final int value;
    private final String desc;
    private static final Map<Integer, SopTaskType> MAP;

    private SopTaskType(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public static SopTaskType getType(Integer value) {
        return MAP.get(value);
    }

    public static String getDescByValue(Integer value) {
        if (Objects.isNull(value)) {
            return null;
        }
        return Optional.ofNullable(MAP.get(value)).map(SopTaskType::getDesc).orElse(null);
    }

    public int getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        MAP = ImmutableMap.copyOf(Arrays.stream(SopTaskType.values()).collect(Collectors.toMap(SopTaskType::getValue, Function.identity())));
    }
}

