/*
 * Decompiled with CFR 0.152.
 */
package com.kuaike.scrm.common.enums;

import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public enum JsMsgType {
    TEXT("text", "\u6587\u672c", true),
    IMAGE("image", "\u56fe\u7247"),
    VIDEO("video", "\u89c6\u9891"),
    FILE("file", "\u6587\u4ef6"),
    NEWS("news", "\u56fe\u6587"),
    MINI_PROGRAM("miniprogram", "\u5c0f\u7a0b\u5e8f"),
    MEETING("meeting", "\u4f1a\u8bae", true),
    FRIEND_FISSION_WORDS("ffwords", "\u597d\u53cb\u88c2\u53d8", true),
    VOICE("voice", "\u8bed\u97f3"),
    NOTICE("notice", "\u7fa4\u516c\u544a");

    private final String value;
    private final String desc;
    private final boolean isText;
    private static final Set<String> CACHE;
    private static final Map<String, JsMsgType> MAP;

    private JsMsgType(String value, String desc) {
        this(value, desc, false);
    }

    private JsMsgType(String value, String desc, boolean isText) {
        this.value = value;
        this.desc = desc;
        this.isText = isText;
    }

    public String getValue() {
        return this.value;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isText() {
        return this.isText;
    }

    public static boolean contains(String typeName) {
        if (StringUtils.isBlank((CharSequence)typeName)) {
            return false;
        }
        return CACHE.contains(typeName.toLowerCase(Locale.getDefault()));
    }

    public static JsMsgType get(String type) {
        return MAP.get(type.toLowerCase(Locale.getDefault()));
    }

    static {
        CACHE = Arrays.stream(JsMsgType.values()).map(a -> a.value).collect(Collectors.toSet());
        MAP = Arrays.stream(JsMsgType.values()).collect(Collectors.toMap(JsMsgType::getValue, Function.identity()));
    }
}

