/**
 * kuaikeguanjia.com Inc.
 * Copyright (c) 2014-2020 All Rights Reserved.
 */
package com.kuaike.scrm.vip.dto.model;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * 企业微信上报的消息结构
 * 
 * @title WeworkMessage
 * @author yanmaoyuan
 * @date 2020年11月10日
 * @version 1.0
 */
@Data
@SuppressWarnings("pmd:BooleanGetMethodName")
public class WeworkMessage implements Serializable {

    private static final long serialVersionUID = 1L;

    private String uniqueId;

    // 上报消息的机器人ID
    private String weworkId;

    // 上报消息时生成的requestId
    private String requestId;

    //企业Id
    private String corpId;

    //当前群聊的群主ID
    private String owner;

    /**
     * 下面是会话相关的字段
     */
    // 会话类型 conversationType 0-私聊 1-群聊
    private Integer conType;

    // 会话ID conversationId。私聊时为联系人ID，群聊时为群ID。
    // 系统通知也会以会话的形式上报，会话ID类似于 100031 。
    private String conId;

    // 标识这个会话是内部还是外部
    private Integer externalFlag;

    //某种远端Id，具体含义未知
    private String remoteId;
    
    //////// 发送者

    //发送者Id
    private String senderId;

    //发送者
    private String senderName;

    //发送场景，具体未知
    private Integer sendScene;

    //发送时间
    private Date sendTime;

    // 数据上报更新时间
    private Date updateTime;

    ////////// 接收者

    // 接收者Id，默认为0
    private String receiverId;// 理论上这个字段的值总是与weworkId相同

    /**
     * 下面是企微消息的原始形式
     */
    // 消息的appInfo (疑似唯一)
    private String appInfo;

    // 这个ID是企微客户端在本地记录的ID，格式：高4字节 秒级时间戳(客户端本地时间)，低4字节 32位随机整数。
    private String msgId;

    // 企业微信消息类型
    private Integer contentType;

    // 消息内容原本为序列化的protobuf字节流，采用base64编码后上报。
    private String contentBase64;

    // 消息内容
    private String content;

    /**
     * 下面的消息内容是从contentBase64中反序列化出来的数据。
     * 具体每一个字段，根据contentType的不同可能有不同的含义。详见字段注释
     */
    // 文本消息中 @ 的群成员
    private List<WeworkIdAndNickame> atMembers;

    // 图片、语音、视频、文件等下载地址；超链接的linkUrl
    private String url;

    // 链接的标题文本
    private String title;

    // 链接卡片的描述文本
    private String description;

    // 链接卡片的图标url；视频的previewImgUrl
    private String thumbUrl;

    // 文件id
    private String fileId;

    // 文件名
    private String fileName;

    // 图片、语音、视频、文件的大小 (字节数)
    private Long size;

    // 图片、视频的宽度
    private Integer width;

    // 图片、视频的高度
    private Integer height;

    // 语音、视频的时长 (单位: 秒)
    private Integer duration;

    // 个人名片，只在对方发送名片消息时有意义。
    private PersonalCard personalCard;

    // 入群消息(contentType = 1002)中，上报成员的企业微信Id和昵称
    private List<WeworkIdAndNickame> joinMembers;

    private Integer joinScene;

    // 退群消息(contentType = 1003)中，上报成员的企业微信Id和昵称
    private List<WeworkIdAndNickame> exitMembers;

    //用于确定消息真正是否发送成功的状态字段, 默认值是true表示发送成功的， 只有是false单独处理
    private Boolean sendStatus = true;

    private Integer fileStatus;

    private String fileTypeStr;

    private String videoCover;

    private String transcodeFileUrl;

    private String fileUrl;

    private Integer fileType;

    private Integer isTop;

    //引用消息的requestId
    private String quoteMsgRequestId;

    //引用消息
    private WeworkMessage quoteWeworkMessage;

    //是否已撤回 null/0:未撤回 1:已撤回
    private Integer isRevoke;

    public boolean getIsSend() {
        return weworkId.equals(senderId);
    }

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(weworkId), "weworkId not null");
    }

}
