package com.kuaike.scrm.vip.dto.message;

import com.google.common.base.Preconditions;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;
import java.util.Objects;

/**
 * @description:
 * @author: liuguohong
 * @create: 2020/11/18 15:09
 */
@Data
public class WeworkMessageIndex {
    private String uniqueId;
    private Date sendTime;

    public void validate() {
        Preconditions.checkArgument(StringUtils.isNotBlank(uniqueId), "uniqueId not null");
        if (Objects.isNull(sendTime)) {
            sendTime = new Date();
        }
    }
}
