package com.kuaike.scrm.vip.dto.enums;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhangjing
 * @date 2020/12/18 11:14 上午
 */
public enum FriendshipEnum {

    FRIEND(1, "好友"),
    DELETED(2, "已删除(曾经是好友)"),
    ZOMBIE(3, "僵尸粉"),
    NOT_FRIEND(4, "不是好友");

    private final Integer value;

    private final String desc;

    public String getDesc() {
        return desc;
    }

    public Integer getValue() {
        return value;
    }

    FriendshipEnum(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    private static final Map<Integer, FriendshipEnum> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(FriendshipEnum::getValue, Function.identity()));
    }

    public static FriendshipEnum getInstance(Integer value) {
        return MAP.get(value);
    }
}
