package com.kuaike.scrm.common.enums.applet;

import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2022/01/21
 * 开店状态：0，未完成开店；1，完成开店；
 **/
@Getter
public enum ShopAvailableStatus {

    /**
     * 未完成开店
     */
    UNAVAILABLE(0,"未完成开店"),
    AVAILABLE(1,"完成开店");

    private final Integer status;
    private final String desc;

    ShopAvailableStatus(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    private static final Map<Integer, ShopAvailableStatus> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(ShopAvailableStatus::getStatus, Function.identity()));
    }

    public static boolean isExistByStatus(int type){
        return MAP.containsKey(type);
    }
}