package com.kuaike.scrm.common.enums.applet;

import com.google.common.collect.Maps;
import com.kuaike.scrm.common.enums.alloc.AllocMemberType;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author Created by chenjiaqiang on 2022/01/21
 * 小程序授权状态
 **/
@Getter
public enum AppletAuthStatus {

    /**
     * 未授权
     */
    UNAUTHORIZED(0,"未授权"),
    AUTHORIZED(1,"已授权"),
    DE_AUTHORIZED(2,"取消授权")

    ;

    private final Integer status;
    private final String desc;

    AppletAuthStatus(Integer status, String desc){
        this.status = status;
        this.desc = desc;
    }

    private static final Map<Integer, AppletAuthStatus> MAP;

    static {
        MAP = Arrays.stream(values()).collect(Collectors.toMap(AppletAuthStatus::getStatus, Function.identity()));
    }

    public static boolean isExistByStatus(int type){
        return MAP.containsKey(type);
    }
}