package com.kuaike.scrm.common.enums.addfriend;

import com.kuaike.scrm.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;


/**
 * 1:手动，2：Excel，3:云订单
 *
 * @author lgh
 * <p>
 * 添加手机号类似
 */
public enum TelAddType implements EnumService {
    MANUAL(1, "手动"),
    EXCEL(2, "excel导入"),
    CLOUD_ORDER(3, "云订单"),
    VIP_CHAT_ROOM(4, "加群好友"),
    LEADS(5, "crm-线索加微信"),
    ONE_CLICK(6, "一键加好友");

    private final int type;
    private final String name;

    TelAddType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public int getValue() {
        return type;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, TelAddType> CACHE;

    static {
        CACHE = new HashMap<>(5);
        for (TelAddType item : TelAddType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static TelAddType get(int status) {
        return CACHE.get(status);
    }
}
