package com.kuaike.scrm.common.enums.addfriend;

import com.kuaike.scrm.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

/**
 * @author louis
 * @date 2022/6/15
 */
public enum AddFriendsTaskType implements EnumService {
    NORMAL_ADD(0, "普通添加"),
    ENHANCE_ADD(1, "增强版添加");

    private final int type;
    private final String name;

    AddFriendsTaskType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public int getValue() {
        return type;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, AddFriendsTaskType> CACHE;

    static {
        CACHE = new HashMap<>(5);
        for (AddFriendsTaskType item : AddFriendsTaskType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static AddFriendsTaskType get(int status) {
        return CACHE.get(status);
    }
}
