package com.kuaike.scrm.common.enums.addfriend;

import com.kuaike.scrm.common.enums.EnumService;

import java.util.HashMap;
import java.util.Map;

public enum AddFriendAllocType implements EnumService {
    AVERAGE(1, "平均分配"),
    WEIGHT(2, "按权重分配");

    private final int type;
    private final String name;

    AddFriendAllocType(int type, String name) {
        this.type = type;
        this.name = name;
    }

    @Override
    public int getValue() {
        return type;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, AddFriendAllocType> CACHE;

    static {
        CACHE = new HashMap<>(5);
        for (AddFriendAllocType item : AddFriendAllocType.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static AddFriendAllocType get(int status) {
        return CACHE.get(status);
    }
}
