package com.kuaike.scrm.common.enums;

/**
 * desc:
 *
 * @author yanmaoyuan
 * @date 2021/11/26
 */
public enum WeworkUserSyncStatus {
    INIT_SUITE(0, "尚未开始同步"),// 新授权的成员将会是这个状态
    ONLY_SUITE(1, "第三方未同步"),// 第三方拿到密文userid，不知道明文userid
    ONLY_CORP(2, "内部未同步"),// 通讯录助手拿到明文userid，不知道密文userid
    SYNCHRONIZED(3, "已同步") // 明文userid和密文userid都已知
    ;

    private final int value;
    private final String desc;

    WeworkUserSyncStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    public int getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }
}
