package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */

public enum WeworkActiveStatusEnum implements EnumService {
    ALREADY_ACTIVE(1, "已激活"),
    DISABLED(2, "已禁用"),
    NOT_ACTIVE(4, "未激活"),
    QUIT_CORP(5, "退出企业");

    private final int value;
    private final String name;

    WeworkActiveStatusEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return name;
    }

    private static final Map<Integer, WeworkActiveStatusEnum> CACHE;

    static {
        CACHE = new HashMap<>();
        for (WeworkActiveStatusEnum item : WeworkActiveStatusEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static WeworkActiveStatusEnum get(Integer value) {
        return CACHE.get(value);
    }
}
