package com.kuaike.scrm.common.enums;

import com.google.common.collect.Maps;

import java.util.Map;

/**
 * 任务状态
 * 0：启用，1：禁用
 */
public enum TaskStatus {

    NORMAL(1, "启用"),
    BANED(0, "禁用");

    private final Integer value;
    private final String desc;

    private static final Map<Integer, TaskStatus> MAP;

    static {
        MAP = Maps.newHashMap();
        for (TaskStatus type : TaskStatus.values()) {
            MAP.put(type.value, type);
        }
    }

    public static TaskStatus getType(Integer type) {
        return MAP.get(type);
    }

    public static Integer getValueByDesc(String desc) {
        for (TaskStatus type : TaskStatus.values()) {
            if (desc.equals(type.getDesc())) {
                return type.getValue();
            }
        }
        return null;
    }

    public Integer getValue() {
        return value;
    }

    public String getDesc() {
        return desc;
    }

    TaskStatus(Integer value, String desc) {
        this.value = value;
        this.desc = desc;
    }

}
