package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 */
public enum SopTemplateTaskTypeEnum implements EnumService {
    WEWORK_GROUP_SEND(1, "企微群发"),
    MANUAL_CALL(2, "人工外呼"),
    SMS(3, "短信"),
    BATCH_ADD_FRIEND(4, "批量加好友");

    private final int type;
    private final String desc;

    SopTemplateTaskTypeEnum(int type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return type;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, SopTemplateTaskTypeEnum> CACHE;

    static {
        CACHE = new HashMap<>(4);
        for (SopTemplateTaskTypeEnum item : SopTemplateTaskTypeEnum.values()) {
            CACHE.put(item.getValue(), item);
        }
    }

    public static SopTemplateTaskTypeEnum get(int type) {
        return CACHE.get(type);
    }

}
