package com.kuaike.scrm.common.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author sunwen
 *
 * 接替状态枚举类
 */
public enum RoomStatus implements EnumService{

    NORMAL(1, "正常"),
    BREAK_UP(2, "解散");

    private final int value;
    private final String desc;

    RoomStatus(int value, String desc) {
        this.value = value;
        this.desc = desc;
    }

    @Override
    public int getValue() {
        return value;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    private static final Map<Integer, RoomStatus> cache;

    static {
        cache = new HashMap<>(2);
        for (RoomStatus item : RoomStatus.values()) {
            cache.put(item.getValue(), item);
        }
    }

    public static RoomStatus get(int status) {
        return cache.get(status);
    }
}
